/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.compare.CalendarComparator;
import org.hibernate.type.descriptor.java.internal.CalendarDateJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.CalendarTimeJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.spi.TemporalJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class CalendarJavaDescriptor
extends AbstractBasicJavaDescriptor<Calendar>
implements TemporalJavaDescriptor<Calendar> {
    public static final CalendarJavaDescriptor INSTANCE = new CalendarJavaDescriptor();
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public <X> TemporalJavaDescriptor<X> resolveTypeForPrecision(TemporalType precision, TypeConfiguration scope) {
        if (precision == TemporalType.TIMESTAMP) {
            return this;
        }
        if (precision == TemporalType.TIME) {
            return CalendarTimeJavaDescriptor.INSTANCE;
        }
        if (precision == TemporalType.DATE) {
            return CalendarDateJavaDescriptor.INSTANCE;
        }
        throw new IllegalArgumentException("Unknown JPA TemporalType precision [" + precision + "]");
    }

    protected CalendarJavaDescriptor() {
        super(Calendar.class, CalendarMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(Calendar calendar) {
        return calendar.toInstant().atZone(calendar.getTimeZone().toZoneId()).format(FORMATTER);
    }

    @Override
    public Calendar fromString(String string) {
        ZonedDateTime parsedZonedDateTime = ZonedDateTime.parse(string, FORMATTER);
        return GregorianCalendar.from(parsedZonedDateTime);
    }

    @Override
    public boolean areEqual(Calendar one, Calendar another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return one.get(14) == another.get(14) && one.get(13) == another.get(13) && one.get(12) == another.get(12) && one.get(11) == another.get(11) && one.get(5) == another.get(5) && one.get(2) == another.get(2) && one.get(1) == another.get(1);
    }

    @Override
    public int extractHashCode(Calendar value) {
        int hashCode = 1;
        hashCode = 31 * hashCode + value.get(14);
        hashCode = 31 * hashCode + value.get(13);
        hashCode = 31 * hashCode + value.get(12);
        hashCode = 31 * hashCode + value.get(11);
        hashCode = 31 * hashCode + value.get(5);
        hashCode = 31 * hashCode + value.get(2);
        hashCode = 31 * hashCode + value.get(1);
        return hashCode;
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(93);
    }

    @Override
    public Comparator<Calendar> getComparator() {
        return CalendarComparator.INSTANCE;
    }

    @Override
    public <X> X unwrap(Calendar value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)new Date(value.getTimeInMillis());
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)new Time(value.getTimeInMillis());
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)new Timestamp(value.getTimeInMillis());
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)new java.util.Date(value.getTimeInMillis());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Calendar wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Calendar.class.isInstance(value)) {
            return (Calendar)value;
        }
        if (!java.util.Date.class.isInstance(value)) {
            throw this.unknownWrap(value.getClass());
        }
        GregorianCalendar cal = new GregorianCalendar();
        if (Environment.jvmHasTimestampBug()) {
            long milliseconds = ((java.util.Date)value).getTime();
            long nanoseconds = Timestamp.class.isInstance(value) ? (long)((Timestamp)value).getNanos() : 0L;
            cal.setTime(new java.util.Date(milliseconds + nanoseconds / 1000000L));
        } else {
            cal.setTime((java.util.Date)value);
        }
        return cal;
    }

    public static class CalendarMutabilityPlan
    extends MutableMutabilityPlan<Calendar> {
        public static final CalendarMutabilityPlan INSTANCE = new CalendarMutabilityPlan();

        @Override
        public Calendar deepCopyNotNull(Calendar value) {
            return (Calendar)value.clone();
        }
    }
}

