/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.compare.CalendarComparator;
import org.hibernate.type.descriptor.java.internal.CalendarJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.TemporalJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.TemporalSqlDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class CalendarTimeJavaDescriptor
extends AbstractBasicJavaDescriptor<Calendar>
implements TemporalJavaDescriptor<Calendar> {
    public static final CalendarTimeJavaDescriptor INSTANCE = new CalendarTimeJavaDescriptor();
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_TIME;

    protected CalendarTimeJavaDescriptor() {
        super(Calendar.class, CalendarJavaDescriptor.CalendarMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(Calendar calendar) {
        return calendar.toInstant().atZone(calendar.getTimeZone().toZoneId()).format(FORMATTER);
    }

    @Override
    public Calendar fromString(String string) {
        OffsetTime parsedOffsetTime = OffsetTime.parse(string, FORMATTER);
        return GregorianCalendar.from(parsedOffsetTime.atDate(LocalDate.MIN).atZoneSameInstant(parsedOffsetTime.getOffset()));
    }

    @Override
    public boolean areEqual(Calendar one, Calendar another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return one.get(5) == another.get(5) && one.get(2) == another.get(2) && one.get(1) == another.get(1);
    }

    @Override
    public int extractHashCode(Calendar value) {
        int hashCode = 1;
        hashCode = 31 * hashCode + value.get(5);
        hashCode = 31 * hashCode + value.get(2);
        hashCode = 31 * hashCode + value.get(1);
        return hashCode;
    }

    @Override
    public TemporalSqlDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return (TemporalSqlDescriptor)context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(92);
    }

    @Override
    public Comparator<Calendar> getComparator() {
        return CalendarComparator.INSTANCE;
    }

    @Override
    public <X> X unwrap(Calendar value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)new Date(value.getTimeInMillis());
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)new Time(value.getTimeInMillis());
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)new Timestamp(value.getTimeInMillis());
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)new java.util.Date(value.getTimeInMillis());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Calendar wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Calendar.class.isInstance(value)) {
            return (Calendar)value;
        }
        if (!java.util.Date.class.isInstance(value)) {
            throw this.unknownWrap(value.getClass());
        }
        GregorianCalendar cal = new GregorianCalendar();
        if (Environment.jvmHasTimestampBug()) {
            long milliseconds = ((java.util.Date)value).getTime();
            long nanoseconds = Timestamp.class.isInstance(value) ? (long)((Timestamp)value).getNanos() : 0L;
            cal.setTime(new java.util.Date(milliseconds + nanoseconds / 1000000L));
        } else {
            cal.setTime((java.util.Date)value);
        }
        return cal;
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIME;
    }

    @Override
    public <X> TemporalJavaDescriptor<X> resolveTypeForPrecision(TemporalType precision, TypeConfiguration scope) {
        if (precision == TemporalType.TIME) {
            return this;
        }
        TemporalJavaDescriptor baseCalendarDescriptor = (TemporalJavaDescriptor)scope.getJavaTypeDescriptorRegistry().getDescriptor(Calendar.class);
        return baseCalendarDescriptor.resolveTypeForPrecision(precision, scope);
    }
}

