/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.Primitive;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class CharacterJavaDescriptor
extends AbstractBasicJavaDescriptor<Character>
implements Primitive<Character> {
    public static final CharacterJavaDescriptor INSTANCE = new CharacterJavaDescriptor();

    public CharacterJavaDescriptor() {
        super(Character.class);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(1);
    }

    @Override
    public String toString(Character value) {
        return value.toString();
    }

    @Override
    public Character fromString(String string) {
        if (string.length() != 1) {
            throw new HibernateException("multiple or zero characters found parsing string");
        }
        return Character.valueOf(string.charAt(0));
    }

    @Override
    public <X> X unwrap(Character value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Character.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.toString();
        }
        if (Number.class.isAssignableFrom(type)) {
            return (X)Short.valueOf((short)value.charValue());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Character wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Character.class.isInstance(value)) {
            return (Character)value;
        }
        if (String.class.isInstance(value)) {
            String str = (String)value;
            return Character.valueOf(str.charAt(0));
        }
        if (Number.class.isInstance(value)) {
            Number nbr = (Number)value;
            return Character.valueOf((char)nbr.shortValue());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public Class getPrimitiveClass() {
        return Character.TYPE;
    }

    @Override
    public Character getDefaultValue() {
        throw new UnsupportedOperationException("char has no non-null default");
    }
}

