/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.type.descriptor.java.internal.StringJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class ClassJavaDescriptor
extends AbstractBasicJavaDescriptor<Class> {
    public static final ClassJavaDescriptor INSTANCE = new ClassJavaDescriptor();

    public ClassJavaDescriptor() {
        super(Class.class);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return StringJavaDescriptor.INSTANCE.getJdbcRecommendedSqlType(context);
    }

    @Override
    public String toString(Class value) {
        return value.getName();
    }

    @Override
    public Class fromString(String string) {
        if (string == null) {
            return null;
        }
        try {
            return ReflectHelper.classForName(string);
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("Unable to locate named class " + string);
        }
    }

    @Override
    public <X> X unwrap(Class value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Class.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Class wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Class.class.isInstance(value)) {
            return (Class)value;
        }
        if (String.class.isInstance(value)) {
            return this.fromString((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }
}

