/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.io.Reader;
import java.io.Serializable;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.ClobImplementer;
import org.hibernate.engine.jdbc.ClobProxy;
import org.hibernate.engine.jdbc.WrappedClob;
import org.hibernate.engine.jdbc.internal.CharacterStreamImpl;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.internal.LobStreamDataHelper;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.spi.IncomparableComparator;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class ClobJavaDescriptor
extends AbstractBasicJavaDescriptor<Clob> {
    public static final ClobJavaDescriptor INSTANCE = new ClobJavaDescriptor();

    public ClobJavaDescriptor() {
        super(Clob.class, ClobMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(Clob value) {
        return LobStreamDataHelper.extractString(value);
    }

    @Override
    public Clob fromString(String string) {
        return ClobProxy.generateProxy(string);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        int jdbcCode = context.isNationalized() ? 2011 : 2005;
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(jdbcCode);
    }

    @Override
    public Comparator<Clob> getComparator() {
        return IncomparableComparator.INSTANCE;
    }

    @Override
    public int extractHashCode(Clob value) {
        return System.identityHashCode(value);
    }

    @Override
    public boolean areEqual(Clob one, Clob another) {
        return one == another;
    }

    @Override
    public <X> X unwrap(Clob value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        try {
            if (CharacterStream.class.isAssignableFrom(type)) {
                if (ClobImplementer.class.isInstance(value)) {
                    return (X)((ClobImplementer)((Object)value)).getUnderlyingStream();
                }
                return (X)new CharacterStreamImpl(LobStreamDataHelper.extractString(value.getCharacterStream()));
            }
            if (Clob.class.isAssignableFrom(type)) {
                Clob clob = WrappedClob.class.isInstance(value) ? ((WrappedClob)((Object)value)).getWrappedClob() : value;
                return (X)clob;
            }
        }
        catch (SQLException e) {
            throw new HibernateException("Unable to access clob stream", e);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Clob wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Clob.class.isAssignableFrom(value.getClass())) {
            return session.getLobCreator().wrap((Clob)value);
        }
        if (Reader.class.isAssignableFrom(value.getClass())) {
            Reader reader = (Reader)value;
            return session.getLobCreator().createClob(LobStreamDataHelper.extractString(reader));
        }
        throw this.unknownWrap(value.getClass());
    }

    public static class ClobMutabilityPlan
    implements MutabilityPlan<Clob> {
        public static final ClobMutabilityPlan INSTANCE = new ClobMutabilityPlan();

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public Clob deepCopy(Clob value) {
            return value;
        }

        @Override
        public Serializable disassemble(Clob value) {
            throw new UnsupportedOperationException("Clobs are not cacheable");
        }

        @Override
        public Clob assemble(Serializable cached) {
            throw new UnsupportedOperationException("Clobs are not cacheable");
        }
    }
}

