/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.util.Currency;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.internal.StringJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class CurrencyJavaDescriptor
extends AbstractBasicJavaDescriptor<Currency> {
    public static final CurrencyJavaDescriptor INSTANCE = new CurrencyJavaDescriptor();

    public CurrencyJavaDescriptor() {
        super(Currency.class);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return StringJavaDescriptor.INSTANCE.getJdbcRecommendedSqlType(context);
    }

    @Override
    public String toString(Currency value) {
        return value.getCurrencyCode();
    }

    @Override
    public Currency fromString(String string) {
        return Currency.getInstance(string);
    }

    @Override
    public <X> X unwrap(Currency value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.getCurrencyCode();
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Currency wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (String.class.isInstance(value)) {
            return Currency.getInstance((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }
}

