/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.TimestampVersionSupport;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.hibernate.type.descriptor.java.internal.CalendarJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.spi.TemporalJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class DateJavaDescriptor
extends AbstractBasicJavaDescriptor<java.util.Date>
implements TemporalJavaDescriptor<java.util.Date> {
    public static final DateJavaDescriptor INSTANCE = new DateJavaDescriptor();
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public <X> TemporalJavaDescriptor<X> resolveTypeForPrecision(TemporalType precision, TypeConfiguration scope) {
        TemporalJavaDescriptor jdbcTimestampDescriptor = (TemporalJavaDescriptor)scope.getJavaTypeDescriptorRegistry().getDescriptor(Timestamp.class);
        return jdbcTimestampDescriptor.resolveTypeForPrecision(precision, scope);
    }

    public DateJavaDescriptor() {
        super(java.util.Date.class, DateMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(java.util.Date value) {
        return FORMATTER.format(value.toInstant());
    }

    @Override
    public java.util.Date fromString(String string) {
        return java.util.Date.from(ZonedDateTime.parse(string, FORMATTER).toInstant());
    }

    @Override
    public boolean areEqual(java.util.Date one, java.util.Date another) {
        if (one == another) {
            return true;
        }
        return one != null && another != null && one.getTime() == another.getTime();
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(91);
    }

    @Override
    public int extractHashCode(java.util.Date value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        return CalendarJavaDescriptor.INSTANCE.extractHashCode(calendar);
    }

    @Override
    public <X> X unwrap(java.util.Date value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(type)) {
            Date rtn = Date.class.isInstance(value) ? (Date)value : new Date(value.getTime());
            return (X)rtn;
        }
        if (Time.class.isAssignableFrom(type)) {
            Time rtn = Time.class.isInstance(value) ? (Time)value : new Time(value.getTime());
            return (X)rtn;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            Timestamp rtn = Timestamp.class.isInstance(value) ? (Timestamp)value : new Timestamp(value.getTime());
            return (X)rtn;
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(value.getTime());
            return (X)cal;
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(value.getTime());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> java.util.Date wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (java.util.Date.class.isInstance(value)) {
            return (java.util.Date)value;
        }
        if (Long.class.isInstance(value)) {
            return new java.util.Date((Long)value);
        }
        if (Calendar.class.isInstance(value)) {
            return new java.util.Date(((Calendar)value).getTimeInMillis());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public VersionSupport<java.util.Date> getVersionSupport() {
        return TimestampVersionSupport.INSTANCE;
    }

    public static class DateMutabilityPlan
    extends MutableMutabilityPlan<java.util.Date> {
        public static final DateMutabilityPlan INSTANCE = new DateMutabilityPlan();

        @Override
        public java.util.Date deepCopyNotNull(java.util.Date value) {
            return new java.util.Date(value.getTime());
        }
    }
}

