/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.time.Duration;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class DurationJavaDescriptor
extends AbstractBasicJavaDescriptor<Duration> {
    public static final DurationJavaDescriptor INSTANCE = new DurationJavaDescriptor();

    public DurationJavaDescriptor() {
        super(Duration.class, ImmutableMutabilityPlan.INSTANCE);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(-5);
    }

    @Override
    public String toString(Duration value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value.toNanos());
    }

    @Override
    public Duration fromString(String string) {
        if (string == null) {
            return null;
        }
        return Duration.ofNanos(Long.valueOf(string));
    }

    @Override
    public <X> X unwrap(Duration duration, Class<X> type, SharedSessionContractImplementor session) {
        if (duration == null) {
            return null;
        }
        if (Duration.class.isAssignableFrom(type)) {
            return (X)duration;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)duration.toString();
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(duration.toNanos());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Duration wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Duration.class.isInstance(value)) {
            return (Duration)value;
        }
        if (Long.class.isInstance(value)) {
            return Duration.ofNanos((Long)value);
        }
        if (String.class.isInstance(value)) {
            return Duration.parse((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }
}

