/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.EmbeddedMutabilityPlan;
import org.hibernate.type.internal.TypeHelper;

public class EmbeddedMutabilityPlanImpl
implements EmbeddedMutabilityPlan {
    private final EmbeddedTypeDescriptor embeddedTypeDescriptor;

    public EmbeddedMutabilityPlanImpl(EmbeddedTypeDescriptor embeddedTypeDescriptor) {
        this.embeddedTypeDescriptor = embeddedTypeDescriptor;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    public Object deepCopy(Object value) {
        Object[] values = this.embeddedTypeDescriptor.getPropertyValues(value);
        this.embeddedTypeDescriptor.visitStateArrayContributors(contributor -> {
            int index = contributor.getStateArrayPosition();
            MutabilityPlan mutabilityPlan = contributor.getMutabilityPlan();
            values[index] = mutabilityPlan.deepCopy(values[index]);
        });
        Object instance = this.embeddedTypeDescriptor.instantiate(null);
        this.embeddedTypeDescriptor.setPropertyValues(instance, values);
        return instance;
    }

    public Serializable disassemble(Object value) {
        throw new NotYetImplementedFor6Exception();
    }

    public Object assemble(Serializable cached) {
        throw new NotYetImplementedFor6Exception();
    }

    public Object replace(Navigable navigable, Object originalValue, Object targetValue, Object owner, Map copyCache, SessionImplementor session) {
        if (originalValue == null) {
            return null;
        }
        Object result = targetValue == null ? this.embeddedTypeDescriptor.instantiate(session) : targetValue;
        Object[] values = TypeHelper.replace(this.embeddedTypeDescriptor, originalValue, targetValue, owner, copyCache, session);
        this.embeddedTypeDescriptor.setPropertyValues(result, values);
        return result;
    }

    public Object replace(Navigable navigable, Object originalValue, Object targetValue, Object owner, Map copyCache, ForeignKeyDirection foreignKeyDirection, SessionImplementor session) {
        if (originalValue == null) {
            return null;
        }
        Object result = targetValue == null ? this.embeddedTypeDescriptor.instantiate(session) : targetValue;
        Object[] values = TypeHelper.replace(this.embeddedTypeDescriptor, originalValue, targetValue, owner, copyCache, foreignKeyDirection, session);
        this.embeddedTypeDescriptor.setPropertyValues(result, values);
        return result;
    }
}

