/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.EntityEntryFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.descriptor.java.spi.EntityMutabilityPlan;

public class EntityMutabilityPlanImpl
implements EntityMutabilityPlan {
    private final EntityEntryFactory entityEntryFactory;
    private final String associatedEntityName;
    private final boolean isMutable;

    public EntityMutabilityPlanImpl(EntityEntryFactory entityEntryFactory, String associatedEntityName, boolean isMutable) {
        this.entityEntryFactory = entityEntryFactory;
        this.associatedEntityName = associatedEntityName;
        this.isMutable = isMutable;
    }

    @Override
    public EntityEntryFactory getEntityEntryFactory() {
        return this.entityEntryFactory;
    }

    @Override
    public boolean isMutable() {
        return this.isMutable;
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public Serializable disassemble(Object value) {
        throw new NotYetImplementedFor6Exception();
    }

    public Object assemble(Serializable cached) {
        throw new NotYetImplementedFor6Exception();
    }

    public Object replace(Navigable navigable, Object originalValue, Object targetValue, Object owner, Map copyCache, SessionImplementor session) {
        if (originalValue == null) {
            return null;
        }
        Object cached = copyCache.get(originalValue);
        if (cached != null) {
            return cached;
        }
        if (originalValue == targetValue) {
            return targetValue;
        }
        if (session.getContextEntityIdentifier(originalValue) == null && ForeignKeys.isTransient(this.associatedEntityName, originalValue, Boolean.FALSE, session)) {
            if (copyCache.containsValue(originalValue)) {
                return originalValue;
            }
            Object copy = session.getFactory().getMetamodel().getEntityDescriptor(this.associatedEntityName).instantiate(null, session);
            copyCache.put(originalValue, copy);
            return copy;
        }
        assert (navigable instanceof EntityTypeDescriptor);
        EntityTypeDescriptor entityDescriptor = (EntityTypeDescriptor)navigable;
        Object id = entityDescriptor.getIdentifier(originalValue);
        if (id == null) {
            throw new AssertionFailure("non-transient entity has a null id: " + originalValue.getClass().getName());
        }
        id = entityDescriptor.getIdentifierDescriptor().getJavaTypeDescriptor().getMutabilityPlan().replace(entityDescriptor, id, null, owner, copyCache, session);
        return session.internalLoad(entityDescriptor.getEntityName(), id, true, false);
    }

    public Object replace(Navigable navigable, Object originalValue, Object targetValue, Object owner, Map copyCache, ForeignKeyDirection foreignKeyDirection, SessionImplementor session) {
        throw new NotYetImplementedFor6Exception();
    }
}

