/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import javax.persistence.EnumType;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class EnumJavaDescriptor<E extends Enum>
extends AbstractBasicJavaDescriptor<E>
implements org.hibernate.type.descriptor.java.spi.EnumJavaDescriptor<E> {
    public EnumJavaDescriptor(Class<E> type) {
        super(type, ImmutableMutabilityPlan.INSTANCE);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        if (context.getEnumeratedType() != null && context.getEnumeratedType() == EnumType.STRING) {
            return context.isNationalized() ? context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(-9) : context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(12);
        }
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(4);
    }

    @Override
    public String toString(E value) {
        return value == null ? "<null>" : ((Enum)value).name();
    }

    @Override
    public E fromString(String string) {
        return string == null ? null : (E)Enum.valueOf(this.getJavaType(), string);
    }

    @Override
    public <X> X unwrap(E value, Class<X> type, SharedSessionContractImplementor session) {
        return (X)value;
    }

    @Override
    public <X> E wrap(X value, SharedSessionContractImplementor session) {
        return (E)((Enum)value);
    }

    @Override
    public Integer toOrdinal(E domainForm) {
        if (domainForm == null) {
            return null;
        }
        return ((Enum)domainForm).ordinal();
    }

    @Override
    public E fromOrdinal(Integer relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (E)((Enum[])this.getJavaType().getEnumConstants())[relationalForm];
    }

    @Override
    public E fromName(String relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (E)Enum.valueOf(this.getJavaType(), relationalForm);
    }

    @Override
    public String toName(E domainForm) {
        if (domainForm == null) {
            return null;
        }
        return ((Enum)domainForm).name();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getJavaType().getName() + ")";
    }
}

