/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.InstantVersionSupport;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.spi.TemporalJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class InstantJavaDescriptor
extends AbstractBasicJavaDescriptor<Instant>
implements TemporalJavaDescriptor<Instant> {
    public static final InstantJavaDescriptor INSTANCE = new InstantJavaDescriptor();

    public InstantJavaDescriptor() {
        super(Instant.class, ImmutableMutabilityPlan.INSTANCE);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(93);
    }

    @Override
    public String toString(Instant value) {
        return DateTimeFormatter.ISO_INSTANT.format(value);
    }

    @Override
    public Instant fromString(String string) {
        return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(string));
    }

    @Override
    public <X> X unwrap(Instant instant, Class<X> type, SharedSessionContractImplementor session) {
        if (instant == null) {
            return null;
        }
        if (Instant.class.isAssignableFrom(type)) {
            return (X)instant;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            ZoneId zoneId = ZoneId.ofOffset("UTC", ZoneOffset.UTC);
            return (X)GregorianCalendar.from(instant.atZone(zoneId));
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)Timestamp.from(instant);
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)Date.from(instant);
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)Time.from(instant);
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)java.util.Date.from(instant);
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(instant.toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Instant wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Instant.class.isInstance(value)) {
            return (Instant)value;
        }
        if (Timestamp.class.isInstance(value)) {
            Timestamp ts = (Timestamp)value;
            return ts.toInstant();
        }
        if (Long.class.isInstance(value)) {
            return Instant.ofEpochMilli((Long)value);
        }
        if (Calendar.class.isInstance(value)) {
            Calendar calendar = (Calendar)value;
            return ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId()).toInstant();
        }
        if (java.util.Date.class.isInstance(value)) {
            return ((java.util.Date)value).toInstant();
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public <X> TemporalJavaDescriptor<X> resolveTypeForPrecision(TemporalType precision, TypeConfiguration scope) {
        return this;
    }

    @Override
    public VersionSupport<Instant> getVersionSupport() {
        return InstantVersionSupport.INSTANCE;
    }
}

