/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.internal.JdbcDateJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.JdbcTimeJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.spi.TemporalJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class JdbcTimestampJavaDescriptor
extends AbstractBasicJavaDescriptor<java.util.Date>
implements TemporalJavaDescriptor<java.util.Date> {
    public static final JdbcTimestampJavaDescriptor INSTANCE = new JdbcTimestampJavaDescriptor();
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

    public JdbcTimestampJavaDescriptor() {
        super(java.util.Date.class, TimestampMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(java.util.Date value) {
        return FORMATTER.format(value.toInstant());
    }

    @Override
    public java.util.Date fromString(String string) {
        return java.util.Date.from(ZonedDateTime.parse(string, FORMATTER).toInstant());
    }

    @Override
    public boolean areEqual(java.util.Date one, java.util.Date another) {
        int n2;
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        long t1 = one.getTime();
        long t2 = another.getTime();
        boolean oneIsTimestamp = Timestamp.class.isInstance(one);
        boolean anotherIsTimestamp = Timestamp.class.isInstance(another);
        int n1 = oneIsTimestamp ? ((Timestamp)one).getNanos() : 0;
        int n = n2 = anotherIsTimestamp ? ((Timestamp)another).getNanos() : 0;
        if (t1 != t2) {
            return false;
        }
        if (oneIsTimestamp && anotherIsTimestamp) {
            int nn1 = n1 % 1000000;
            int nn2 = n2 % 1000000;
            return nn1 == nn2;
        }
        return true;
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(93);
    }

    @Override
    public int extractHashCode(java.util.Date value) {
        return Long.valueOf(value.getTime() / 1000L).hashCode();
    }

    @Override
    public <X> X unwrap(java.util.Date value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            Timestamp rtn = Timestamp.class.isInstance(value) ? (Timestamp)value : new Timestamp(value.getTime());
            return (X)rtn;
        }
        if (Date.class.isAssignableFrom(type)) {
            Date rtn = Date.class.isInstance(value) ? (Date)value : new Date(value.getTime());
            return (X)rtn;
        }
        if (Time.class.isAssignableFrom(type)) {
            Time rtn = Time.class.isInstance(value) ? (Time)value : new Time(value.getTime());
            return (X)rtn;
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(value.getTime());
            return (X)cal;
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(value.getTime());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> java.util.Date wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Timestamp.class.isInstance(value)) {
            return (Timestamp)value;
        }
        if (Long.class.isInstance(value)) {
            return new Timestamp((Long)value);
        }
        if (Calendar.class.isInstance(value)) {
            return new Timestamp(((Calendar)value).getTimeInMillis());
        }
        if (java.util.Date.class.isInstance(value)) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public <X> TemporalJavaDescriptor<X> resolveTypeForPrecision(TemporalType precision, TypeConfiguration scope) {
        if (precision == TemporalType.TIMESTAMP) {
            return this;
        }
        if (precision == TemporalType.TIME) {
            return JdbcTimeJavaDescriptor.INSTANCE;
        }
        if (precision == TemporalType.DATE) {
            return JdbcDateJavaDescriptor.INSTANCE;
        }
        throw new IllegalArgumentException("Unrecognized JPA TemporalType precision [" + precision + "]");
    }

    public static class TimestampMutabilityPlan
    extends MutableMutabilityPlan<java.util.Date> {
        public static final TimestampMutabilityPlan INSTANCE = new TimestampMutabilityPlan();

        @Override
        public java.util.Date deepCopyNotNull(java.util.Date value) {
            if (value instanceof Timestamp) {
                Timestamp orig = (Timestamp)value;
                Timestamp ts = new Timestamp(orig.getTime());
                ts.setNanos(orig.getNanos());
                return ts;
            }
            return new java.util.Date(value.getTime());
        }
    }
}

