/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.persistence.TemporalType;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.spi.TemporalJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class LocalDateJavaDescriptor
extends AbstractBasicJavaDescriptor<LocalDate>
implements TemporalJavaDescriptor<LocalDate> {
    public static final LocalDateJavaDescriptor INSTANCE = new LocalDateJavaDescriptor();
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ENGLISH);

    public LocalDateJavaDescriptor() {
        super(LocalDate.class, ImmutableMutabilityPlan.INSTANCE);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(91);
    }

    @Override
    public String toString(LocalDate value) {
        return FORMATTER.format(value);
    }

    @Override
    public LocalDate fromString(String string) {
        return LocalDate.from(FORMATTER.parse(string));
    }

    @Override
    public <X> X unwrap(LocalDate value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (LocalDate.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)Date.valueOf(value);
        }
        LocalDateTime localDateTime = value.atStartOfDay();
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)Timestamp.valueOf(localDateTime);
        }
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(zonedDateTime);
        }
        Instant instant = zonedDateTime.toInstant();
        if (java.util.Date.class.equals(type)) {
            return (X)java.util.Date.from(instant);
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(instant.toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> LocalDate wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (LocalDate.class.isInstance(value)) {
            return (LocalDate)value;
        }
        if (Timestamp.class.isInstance(value)) {
            Timestamp ts = (Timestamp)value;
            return LocalDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault()).toLocalDate();
        }
        if (Long.class.isInstance(value)) {
            Instant instant = Instant.ofEpochMilli((Long)value);
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate();
        }
        if (Calendar.class.isInstance(value)) {
            Calendar calendar = (Calendar)value;
            return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId()).toLocalDate();
        }
        if (java.util.Date.class.isInstance(value)) {
            if (Date.class.isInstance(value)) {
                return ((Date)value).toLocalDate();
            }
            return Instant.ofEpochMilli(((java.util.Date)value).getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.DATE;
    }

    @Override
    public <X> TemporalJavaDescriptor<X> resolveTypeForPrecision(TemporalType precision, TypeConfiguration scope) {
        if (precision == TemporalType.DATE) {
            return this;
        }
        if (precision == TemporalType.TIMESTAMP) {
            return (TemporalJavaDescriptor)scope.getJavaTypeDescriptorRegistry().getDescriptor(LocalDateTime.class);
        }
        if (precision == TemporalType.TIME) {
            throw new IllegalArgumentException("Cannot treat LocalDateTime as javax.persistence.TemporalType#TIME");
        }
        throw new IllegalArgumentException("Unrecognized JPA TemporalType precision [" + precision + "]");
    }
}

