/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.persistence.TemporalType;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.LocalDateTimeVersionSupport;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.spi.TemporalJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class LocalDateTimeJavaDescriptor
extends AbstractBasicJavaDescriptor<LocalDateTime>
implements TemporalJavaDescriptor<LocalDateTime> {
    private static final Logger log = Logger.getLogger(LocalDateTimeJavaDescriptor.class);
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S", Locale.ENGLISH);
    public static final LocalDateTimeJavaDescriptor INSTANCE = new LocalDateTimeJavaDescriptor();

    public LocalDateTimeJavaDescriptor() {
        super(LocalDateTime.class, ImmutableMutabilityPlan.INSTANCE);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(93);
    }

    @Override
    public String toString(LocalDateTime value) {
        return FORMATTER.format(value);
    }

    @Override
    public LocalDateTime fromString(String string) {
        return LocalDateTime.from(FORMATTER.parse(string));
    }

    @Override
    public <X> X unwrap(LocalDateTime value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (LocalDateTime.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            Instant instant = value.atZone(ZoneId.systemDefault()).toInstant();
            return (X)Timestamp.from(instant);
        }
        if (Date.class.isAssignableFrom(type)) {
            Instant instant = value.atZone(ZoneId.systemDefault()).toInstant();
            return (X)Date.from(instant);
        }
        if (Time.class.isAssignableFrom(type)) {
            Instant instant = value.atZone(ZoneId.systemDefault()).toInstant();
            return (X)Time.from(instant);
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            Instant instant = value.atZone(ZoneId.systemDefault()).toInstant();
            return (X)java.util.Date.from(instant);
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(value.atZone(ZoneId.systemDefault()));
        }
        if (Long.class.isAssignableFrom(type)) {
            Instant instant = value.atZone(ZoneId.systemDefault()).toInstant();
            return (X)Long.valueOf(instant.toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> LocalDateTime wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (LocalDateTime.class.isInstance(value)) {
            return (LocalDateTime)value;
        }
        if (Timestamp.class.isInstance(value)) {
            Timestamp ts = (Timestamp)value;
            return LocalDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
        }
        if (Long.class.isInstance(value)) {
            Instant instant = Instant.ofEpochMilli((Long)value);
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        if (Calendar.class.isInstance(value)) {
            Calendar calendar = (Calendar)value;
            return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        if (java.util.Date.class.isInstance(value)) {
            Timestamp ts = (Timestamp)value;
            Instant instant = Instant.ofEpochMilli(ts.getTime());
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public <X> TemporalJavaDescriptor<X> resolveTypeForPrecision(TemporalType precision, TypeConfiguration scope) {
        if (precision == TemporalType.TIMESTAMP) {
            return this;
        }
        if (precision == TemporalType.DATE) {
            return (TemporalJavaDescriptor)scope.getJavaTypeDescriptorRegistry().getDescriptor(LocalDate.class);
        }
        if (precision == TemporalType.TIME) {
            log.debugf("No JPA TemporalType#TIME Java representation for LocalDateTime, using LocalDateTime", new Object[0]);
            return this;
        }
        throw new IllegalArgumentException("Unrecognized JPA TemporalType precision [" + precision + "]");
    }

    @Override
    public VersionSupport<LocalDateTime> getVersionSupport() {
        return LocalDateTimeVersionSupport.INSTANCE;
    }
}

