/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.persistence.TemporalType;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.spi.TemporalJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class LocalTimeJavaDescriptor
extends AbstractBasicJavaDescriptor<LocalTime>
implements TemporalJavaDescriptor<LocalTime> {
    public static final LocalTimeJavaDescriptor INSTANCE = new LocalTimeJavaDescriptor();
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ENGLISH);

    public LocalTimeJavaDescriptor() {
        super(LocalTime.class, ImmutableMutabilityPlan.INSTANCE);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(92);
    }

    @Override
    public String toString(LocalTime value) {
        return FORMATTER.format(value);
    }

    @Override
    public LocalTime fromString(String string) {
        return (LocalTime)FORMATTER.parse(string);
    }

    @Override
    public <X> X unwrap(LocalTime value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (LocalDate.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)Time.valueOf(value);
        }
        ZonedDateTime zonedDateTime = value.atDate(LocalDate.of(1970, 1, 1)).atZone(ZoneId.systemDefault());
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(zonedDateTime);
        }
        Instant instant = zonedDateTime.toInstant();
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)Timestamp.from(instant);
        }
        if (Date.class.equals(type)) {
            return (X)Date.from(instant);
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(instant.toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> LocalTime wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (LocalTime.class.isInstance(value)) {
            return (LocalTime)value;
        }
        if (Timestamp.class.isInstance(value)) {
            Timestamp ts = (Timestamp)value;
            return LocalDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault()).toLocalTime();
        }
        if (Long.class.isInstance(value)) {
            Instant instant = Instant.ofEpochMilli((Long)value);
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalTime();
        }
        if (Calendar.class.isInstance(value)) {
            Calendar calendar = (Calendar)value;
            return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId()).toLocalTime();
        }
        if (Date.class.isInstance(value)) {
            Date ts = (Date)value;
            Instant instant = Instant.ofEpochMilli(ts.getTime());
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalTime();
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIME;
    }

    @Override
    public <X> TemporalJavaDescriptor<X> resolveTypeForPrecision(TemporalType precision, TypeConfiguration scope) {
        if (precision == TemporalType.TIME) {
            return this;
        }
        if (precision == TemporalType.TIMESTAMP) {
            return (TemporalJavaDescriptor)scope.getJavaTypeDescriptorRegistry().getDescriptor(LocalTime.class);
        }
        if (precision == TemporalType.DATE) {
            throw new IllegalArgumentException("Cannot treat LocalDate as javax.persistence.TemporalType#TIME");
        }
        throw new IllegalArgumentException("Unrecognized JPA TemporalType precision [" + precision + "]");
    }
}

