/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.io.Reader;
import java.io.Serializable;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.NClobImplementer;
import org.hibernate.engine.jdbc.NClobProxy;
import org.hibernate.engine.jdbc.WrappedClob;
import org.hibernate.engine.jdbc.internal.CharacterStreamImpl;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.internal.LobStreamDataHelper;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.spi.IncomparableComparator;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class NClobJavaDescriptor
extends AbstractBasicJavaDescriptor<NClob> {
    public static final NClobJavaDescriptor INSTANCE = new NClobJavaDescriptor();

    public NClobJavaDescriptor() {
        super(NClob.class, NClobMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(NClob value) {
        return LobStreamDataHelper.extractString(value);
    }

    @Override
    public NClob fromString(String string) {
        return NClobProxy.generateProxy(string);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        int jdbcCode = context.isNationalized() ? 2011 : 2005;
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(jdbcCode);
    }

    @Override
    public Comparator<NClob> getComparator() {
        return IncomparableComparator.INSTANCE;
    }

    @Override
    public int extractHashCode(NClob value) {
        return System.identityHashCode(value);
    }

    @Override
    public boolean areEqual(NClob one, NClob another) {
        return one == another;
    }

    @Override
    public <X> X unwrap(NClob value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        try {
            if (CharacterStream.class.isAssignableFrom(type)) {
                if (NClobImplementer.class.isInstance(value)) {
                    return (X)((NClobImplementer)((Object)value)).getUnderlyingStream();
                }
                return (X)new CharacterStreamImpl(LobStreamDataHelper.extractString(value.getCharacterStream()));
            }
            if (Clob.class.isAssignableFrom(type)) {
                NClob clob = WrappedClob.class.isInstance(value) ? ((WrappedClob)((Object)value)).getWrappedClob() : value;
                return (X)clob;
            }
        }
        catch (SQLException e) {
            throw new HibernateException("Unable to access clob stream", e);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> NClob wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (NClob.class.isAssignableFrom(value.getClass())) {
            return session.getLobCreator().wrap((NClob)value);
        }
        if (Reader.class.isAssignableFrom(value.getClass())) {
            Reader reader = (Reader)value;
            return session.getLobCreator().createNClob(LobStreamDataHelper.extractString(reader));
        }
        throw this.unknownWrap(value.getClass());
    }

    public static class NClobMutabilityPlan
    implements MutabilityPlan<NClob> {
        public static final NClobMutabilityPlan INSTANCE = new NClobMutabilityPlan();

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public NClob deepCopy(NClob value) {
            return value;
        }

        @Override
        public Serializable disassemble(NClob value) {
            throw new UnsupportedOperationException("LOB locators are not cacheable");
        }

        @Override
        public NClob assemble(Serializable cached) {
            throw new UnsupportedOperationException("LOB locators are not cacheable");
        }
    }
}

