/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.OffsetDateTimeVersionSupport;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.spi.TemporalJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class OffsetDateTimeJavaDescriptor
extends AbstractBasicJavaDescriptor<OffsetDateTime>
implements TemporalJavaDescriptor<OffsetDateTime> {
    private static final Logger log = Logger.getLogger(OffsetDateTimeJavaDescriptor.class);
    public static final OffsetDateTimeJavaDescriptor INSTANCE = new OffsetDateTimeJavaDescriptor();

    public OffsetDateTimeJavaDescriptor() {
        super(OffsetDateTime.class, ImmutableMutabilityPlan.INSTANCE);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(93);
    }

    @Override
    public String toString(OffsetDateTime value) {
        return value.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    @Override
    public OffsetDateTime fromString(String string) {
        return OffsetDateTime.parse(string, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    @Override
    public <X> X unwrap(OffsetDateTime offsetDateTime, Class<X> type, SharedSessionContractImplementor session) {
        if (offsetDateTime == null) {
            return null;
        }
        if (OffsetDateTime.class.isAssignableFrom(type)) {
            return (X)offsetDateTime;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(offsetDateTime.toZonedDateTime());
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)Timestamp.from(offsetDateTime.toInstant());
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)Date.from(offsetDateTime.toInstant());
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)Time.from(offsetDateTime.toInstant());
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)java.util.Date.from(offsetDateTime.toInstant());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(offsetDateTime.toInstant().toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> OffsetDateTime wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (OffsetDateTime.class.isInstance(value)) {
            return (OffsetDateTime)value;
        }
        if (Timestamp.class.isInstance(value)) {
            Timestamp ts = (Timestamp)value;
            return OffsetDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
        }
        if (java.util.Date.class.isInstance(value)) {
            java.util.Date date = (java.util.Date)value;
            return OffsetDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        if (Long.class.isInstance(value)) {
            return OffsetDateTime.ofInstant(Instant.ofEpochMilli((Long)value), ZoneId.systemDefault());
        }
        if (Calendar.class.isInstance(value)) {
            Calendar calendar = (Calendar)value;
            return OffsetDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public <X> TemporalJavaDescriptor<X> resolveTypeForPrecision(TemporalType precision, TypeConfiguration scope) {
        if (precision == TemporalType.TIMESTAMP) {
            return this;
        }
        if (precision == TemporalType.DATE) {
            log.debugf("No JPA TemporalType#TIME Java representation for LocalDateTime, using LocalDateTime", new Object[0]);
            return this;
        }
        if (precision == TemporalType.TIME) {
            return (TemporalJavaDescriptor)scope.getJavaTypeDescriptorRegistry().getDescriptor(OffsetTime.class);
        }
        throw new IllegalArgumentException("Unrecognized JPA TemporalType precision [" + precision + "]");
    }

    @Override
    public VersionSupport<OffsetDateTime> getVersionSupport() {
        return OffsetDateTimeVersionSupport.INSTANCE;
    }
}

