/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.type.descriptor.java.internal.LobStreamDataHelper;
import org.hibernate.type.descriptor.java.internal.PrimitiveByteArrayJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.MutableMutabilityPlan;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class SerializableJavaDescriptor<T extends Serializable>
extends AbstractBasicJavaDescriptor<T> {
    public static final SerializableJavaDescriptor<Serializable> INSTANCE = new SerializableJavaDescriptor<Serializable>(Serializable.class);

    public SerializableJavaDescriptor(Class<T> type) {
        super(type, Serializable.class.equals(type) ? SerializableMutabilityPlan.INSTANCE : new SerializableMutabilityPlan<T>(type));
    }

    @Override
    public String toString(T value) {
        return PrimitiveByteArrayJavaDescriptor.INSTANCE.toString(this.toBytes(value));
    }

    @Override
    public T fromString(String string) {
        return this.fromBytes(PrimitiveByteArrayJavaDescriptor.INSTANCE.fromString(string));
    }

    @Override
    public boolean areEqual(T one, T another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return one.equals(another) || PrimitiveByteArrayJavaDescriptor.INSTANCE.areEqual(this.toBytes(one), this.toBytes(another));
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(-3);
    }

    @Override
    public int extractHashCode(T value) {
        return PrimitiveByteArrayJavaDescriptor.INSTANCE.extractHashCode(this.toBytes(value));
    }

    @Override
    public <X> X unwrap(T value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (X)value;
        }
        if (byte[].class.isAssignableFrom(type)) {
            return (X)this.toBytes(value);
        }
        if (InputStream.class.isAssignableFrom(type)) {
            return (X)new ByteArrayInputStream(this.toBytes(value));
        }
        if (BinaryStream.class.isAssignableFrom(type)) {
            return (X)new BinaryStreamImpl(this.toBytes(value));
        }
        if (Blob.class.isAssignableFrom(type)) {
            return (X)session.getLobCreator().createBlob(this.toBytes(value));
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> T wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (byte[].class.isInstance(value)) {
            return this.fromBytes((byte[])value);
        }
        if (InputStream.class.isInstance(value)) {
            return this.fromBytes(LobStreamDataHelper.extractBytes((InputStream)value));
        }
        if (Blob.class.isInstance(value)) {
            try {
                return this.fromBytes(LobStreamDataHelper.extractBytes(((Blob)value).getBinaryStream()));
            }
            catch (SQLException e) {
                throw new HibernateException(e);
            }
        }
        if (this.getJavaType() == null && this.getJavaType().isInstance(value)) {
            return (T)((Serializable)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    protected byte[] toBytes(T value) {
        return SerializationHelper.serialize(value);
    }

    protected T fromBytes(byte[] bytes) {
        if (this.getJavaType() == null) {
            throw new IllegalStateException("Cannot read bytes for Serializable type");
        }
        return (T)((Serializable)SerializationHelper.deserialize(bytes, this.getJavaType().getClassLoader()));
    }

    public static class SerializableMutabilityPlan<S extends Serializable>
    extends MutableMutabilityPlan<S> {
        private final Class<S> type;
        public static final SerializableMutabilityPlan<Serializable> INSTANCE = new SerializableMutabilityPlan<Serializable>(Serializable.class);

        public SerializableMutabilityPlan(Class<S> type) {
            this.type = type;
        }

        @Override
        public S deepCopyNotNull(S value) {
            return (S)((Serializable)SerializationHelper.clone(value));
        }
    }
}

