/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.util.Comparator;
import java.util.TimeZone;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.internal.StringJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class TimeZoneJavaDescriptor
extends AbstractBasicJavaDescriptor<TimeZone> {
    public static final TimeZoneJavaDescriptor INSTANCE = new TimeZoneJavaDescriptor();

    public TimeZoneJavaDescriptor() {
        super(TimeZone.class);
    }

    @Override
    public String toString(TimeZone value) {
        return value.getID();
    }

    @Override
    public TimeZone fromString(String string) {
        return TimeZone.getTimeZone(string);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return StringJavaDescriptor.INSTANCE.getJdbcRecommendedSqlType(context);
    }

    @Override
    public Comparator<TimeZone> getComparator() {
        return TimeZoneComparator.INSTANCE;
    }

    @Override
    public <X> X unwrap(TimeZone value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> TimeZone wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (String.class.isInstance(value)) {
            return this.fromString((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    public static class TimeZoneComparator
    implements Comparator<TimeZone> {
        public static final TimeZoneComparator INSTANCE = new TimeZoneComparator();

        @Override
        public int compare(TimeZone o1, TimeZone o2) {
            return o1.getID().compareTo(o2.getID());
        }
    }
}

