/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.io.Serializable;
import java.util.Comparator;
import java.util.UUID;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.BytesHelper;
import org.hibernate.type.descriptor.java.internal.StringJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class UUIDJavaDescriptor
extends AbstractBasicJavaDescriptor<UUID> {
    public static final UUIDJavaDescriptor INSTANCE = new UUIDJavaDescriptor();

    public UUIDJavaDescriptor() {
        super(UUID.class);
    }

    @Override
    public String toString(UUID value) {
        return value.toString();
    }

    @Override
    public UUID fromString(String string) {
        return UUID.fromString(string);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return StringJavaDescriptor.INSTANCE.getJdbcRecommendedSqlType(context);
    }

    @Override
    public Comparator<UUID> getComparator() {
        return UUIDComparator.INSTANCE;
    }

    @Override
    public <X> X unwrap(UUID value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> UUID wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (String.class.isInstance(value)) {
            return this.fromString((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    public static class ToBytesTransformer
    implements ValueTransformer {
        public static final ToBytesTransformer INSTANCE = new ToBytesTransformer();

        public byte[] transform(UUID uuid) {
            byte[] bytes = new byte[16];
            System.arraycopy(BytesHelper.fromLong(uuid.getMostSignificantBits()), 0, bytes, 0, 8);
            System.arraycopy(BytesHelper.fromLong(uuid.getLeastSignificantBits()), 0, bytes, 8, 8);
            return bytes;
        }

        @Override
        public UUID parse(Object value) {
            byte[] msb = new byte[8];
            byte[] lsb = new byte[8];
            System.arraycopy(value, 0, msb, 0, 8);
            System.arraycopy(value, 8, lsb, 0, 8);
            return new UUID(BytesHelper.asLong(msb), BytesHelper.asLong(lsb));
        }
    }

    public static class ToStringTransformer
    implements ValueTransformer {
        public static final ToStringTransformer INSTANCE = new ToStringTransformer();

        public String transform(UUID uuid) {
            return uuid.toString();
        }

        @Override
        public UUID parse(Object value) {
            return UUID.fromString((String)value);
        }
    }

    public static class PassThroughTransformer
    implements ValueTransformer {
        public static final PassThroughTransformer INSTANCE = new PassThroughTransformer();

        @Override
        public UUID transform(UUID uuid) {
            return uuid;
        }

        @Override
        public UUID parse(Object value) {
            return (UUID)value;
        }
    }

    public static interface ValueTransformer {
        public Serializable transform(UUID var1);

        public UUID parse(Object var1);
    }

    public static class UUIDComparator
    implements Comparator<UUID> {
        public static final UUIDComparator INSTANCE = new UUIDComparator();

        @Override
        public int compare(UUID o1, UUID o2) {
            return o1.compareTo(o2);
        }
    }
}

