/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.internal.StringJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class UrlJavaDescriptor
extends AbstractBasicJavaDescriptor<URL> {
    public static final UrlJavaDescriptor INSTANCE = new UrlJavaDescriptor();

    public UrlJavaDescriptor() {
        super(URL.class);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return StringJavaDescriptor.INSTANCE.getJdbcRecommendedSqlType(context);
    }

    @Override
    public String toString(URL value) {
        return value.toExternalForm();
    }

    @Override
    public URL fromString(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException e) {
            throw new HibernateException("Unable to convertBasic string [" + string + "] to URL : " + e);
        }
    }

    @Override
    public <X> X unwrap(URL value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> URL wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (String.class.isInstance(value)) {
            return this.fromString((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }
}

