/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.spi.TemporalJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class ZonedDateTimeJavaDescriptor
extends AbstractBasicJavaDescriptor<ZonedDateTime>
implements TemporalJavaDescriptor<ZonedDateTime> {
    public static final ZonedDateTimeJavaDescriptor INSTANCE = new ZonedDateTimeJavaDescriptor();

    public ZonedDateTimeJavaDescriptor() {
        super(ZonedDateTime.class, ImmutableMutabilityPlan.INSTANCE);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return null;
    }

    @Override
    public String toString(ZonedDateTime value) {
        return DateTimeFormatter.ISO_ZONED_DATE_TIME.format(value);
    }

    @Override
    public ZonedDateTime fromString(String string) {
        return ZonedDateTime.parse(string, DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    @Override
    public <X> X unwrap(ZonedDateTime zonedDateTime, Class<X> type, SharedSessionContractImplementor session) {
        if (zonedDateTime == null) {
            return null;
        }
        if (ZonedDateTime.class.isAssignableFrom(type)) {
            return (X)zonedDateTime;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(zonedDateTime);
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)Timestamp.from(zonedDateTime.toInstant());
        }
        if (java.sql.Date.class.isAssignableFrom(type)) {
            return (X)java.sql.Date.from(zonedDateTime.toInstant());
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)Time.from(zonedDateTime.toInstant());
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)Date.from(zonedDateTime.toInstant());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(zonedDateTime.toInstant().toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> ZonedDateTime wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (ZonedDateTime.class.isInstance(value)) {
            return (ZonedDateTime)value;
        }
        if (Timestamp.class.isInstance(value)) {
            Timestamp ts = (Timestamp)value;
            return ZonedDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
        }
        if (Date.class.isInstance(value)) {
            Date date = (Date)value;
            return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        if (Long.class.isInstance(value)) {
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli((Long)value), ZoneId.systemDefault());
        }
        if (Calendar.class.isInstance(value)) {
            Calendar calendar = (Calendar)value;
            return ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public <X> TemporalJavaDescriptor<X> resolveTypeForPrecision(TemporalType precision, TypeConfiguration scope) {
        return this;
    }
}

