/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import java.util.Comparator;
import java.util.Objects;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.jboss.logging.Logger;

public abstract class AbstractJavaDescriptor<T>
implements JavaTypeDescriptor<T> {
    private static final Logger log = Logger.getLogger(AbstractJavaDescriptor.class);
    private final String typeName;
    private final Comparator comparator;
    private MutabilityPlan mutabilityPlan;
    private Class javaType;

    public AbstractJavaDescriptor(String typeName, Class javaType, MutabilityPlan mutabilityPlan, Comparator comparator) {
        this.typeName = typeName;
        this.javaType = javaType;
        this.mutabilityPlan = mutabilityPlan;
        this.comparator = comparator;
    }

    protected void setMutabilityPlan(MutabilityPlan mutabilityPlan) {
        this.mutabilityPlan = mutabilityPlan;
    }

    protected void setJavaType(Class javaType) {
        log.debugf("setting Java type to [" + javaType + "]; was [" + this.javaType + "]", new Object[0]);
        this.javaType = javaType;
    }

    @Override
    public Class<T> getJavaType() {
        return this.javaType;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public MutabilityPlan<T> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public Comparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public int extractHashCode(T value) {
        return value.hashCode();
    }

    @Override
    public boolean areEqual(T one, T another) {
        return Objects.equals(one, another);
    }
}

