/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.type.descriptor.java.internal.EnumJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.JavaTypeDescriptorBaseline;
import org.hibernate.type.descriptor.java.internal.JavaTypeDescriptorBasicAdaptor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.VarbinarySqlDescriptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.jboss.logging.Logger;

public class JavaTypeDescriptorRegistry
implements Serializable,
JavaTypeDescriptorBaseline.BaselineTarget {
    private static final Logger log = Logger.getLogger(JavaTypeDescriptorRegistry.class);
    private final TypeConfiguration typeConfiguration;
    private final ConcurrentHashMap<String, JavaTypeDescriptor> descriptorsByName = new ConcurrentHashMap();

    public JavaTypeDescriptorRegistry(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
        JavaTypeDescriptorBaseline.prime(this);
    }

    @Override
    public void addBaselineDescriptor(BasicJavaDescriptor descriptor) {
        if (descriptor.getJavaType() == null) {
            throw new IllegalStateException("Illegal to add BasicJavaTypeDescriptor with null Java type");
        }
        this.addBaselineDescriptor(descriptor.getJavaType(), descriptor);
    }

    @Override
    public void addBaselineDescriptor(Class describedJavaType, BasicJavaDescriptor descriptor) {
        this.performInjections(descriptor);
        this.descriptorsByName.put(describedJavaType.getName(), descriptor);
    }

    public <T> JavaTypeDescriptor<T> getDescriptor(String javaTypeName) {
        return this.getDescriptor(javaTypeName, (String name, JavaTypeDescriptorRegistry reg) -> null);
    }

    public <T> JavaTypeDescriptor<T> getDescriptor(String javaTypeName, BiFunction<String, JavaTypeDescriptorRegistry, JavaTypeDescriptor> fallback) {
        if (javaTypeName == null) {
            throw new IllegalArgumentException("Java type name passed to locate Java type descriptor cannot be null");
        }
        JavaTypeDescriptor javaTypeDescriptor = this.descriptorsByName.get(javaTypeName);
        return javaTypeDescriptor != null ? javaTypeDescriptor : fallback.apply(javaTypeName, this);
    }

    public <T> JavaTypeDescriptor<T> getDescriptor(Class<T> javaType) {
        return this.getDescriptor(javaType, (String s, JavaTypeDescriptorRegistry r) -> null);
    }

    public <T> JavaTypeDescriptor<T> getOrMakeJavaDescriptor(Class<T> javaType) {
        return this.getDescriptor(javaType, (String s, JavaTypeDescriptorRegistry registry) -> {
            AbstractBasicJavaDescriptor fallbackDescriptor = javaType.isEnum() ? new EnumJavaDescriptor(javaType) : (Serializable.class.isAssignableFrom(javaType) ? new OnTheFlySerializableJavaDescriptor(javaType) : new JavaTypeDescriptorBasicAdaptor(javaType));
            registry.addDescriptor(fallbackDescriptor);
            return fallbackDescriptor;
        });
    }

    public <T> JavaTypeDescriptor<T> getOrMakeJavaDescriptor(Class<T> javaType, BiFunction<String, JavaTypeDescriptorRegistry, JavaTypeDescriptor> fallback) {
        return this.getDescriptor(javaType, (String s, JavaTypeDescriptorRegistry registry) -> {
            JavaTypeDescriptor suppliedFallback = (JavaTypeDescriptor)fallback.apply((String)s, (JavaTypeDescriptorRegistry)registry);
            if (suppliedFallback != null) {
                registry.addDescriptor(suppliedFallback);
                return suppliedFallback;
            }
            return this.getOrMakeJavaDescriptor(javaType);
        });
    }

    public <T> JavaTypeDescriptor<T> getDescriptor(Class<T> javaType, BiFunction<String, JavaTypeDescriptorRegistry, JavaTypeDescriptor> fallback) {
        if (javaType == null) {
            throw new IllegalArgumentException("Java type passed to locate Java type descriptor cannot be null");
        }
        if (javaType.isArray()) {
            return this.getDescriptor(Object[].class.getName(), fallback);
        }
        return this.getDescriptor(javaType.getTypeName(), fallback);
    }

    private <T> BasicJavaDescriptor<T> makeOnTheFlyJavaTypeDescriptor(Class<T> javaType) {
        if (javaType.isEnum()) {
            return new EnumJavaDescriptor<T>(javaType);
        }
        if (Serializable.class.isInstance(javaType)) {
            log.debugf("Could not find matching JavaTypeDescriptor for requested Java class [%s]; using fallback via its Serializable interface.  This means Hibernate does not know how to perform certain basic operations in relation to this Java typewhich can lead to those operations having a large performance impact.  " + this.solution(), new Object[]{javaType.getName(), JavaTypeDescriptorRegistry.class.getName(), TypeContributor.class.getName(), TypeConfiguration.class.getName()});
            return new OnTheFlySerializableJavaDescriptor<T>(javaType);
        }
        throw new HibernateException(String.format(Locale.ROOT, "Cannot create on-the-fly JavaTypeDescriptor for given Java type: %s.  " + this.solution(), TypeContributor.class.getName(), TypeConfiguration.class.getName()));
    }

    private String solution() {
        return "Consider registering these JavaTypeDescriptors with the %s during bootstrap,  either directly or through a registered %s accessing the %s ";
    }

    public void addDescriptor(JavaTypeDescriptor descriptor) {
        this.addDescriptorInternal(descriptor.getTypeName(), descriptor);
    }

    private void addDescriptorInternal(JavaTypeDescriptor descriptor) {
        this.addDescriptorInternal(descriptor.getTypeName(), descriptor);
    }

    private void addDescriptorInternal(Class javaType, JavaTypeDescriptor descriptor) {
        this.addDescriptorInternal(javaType.getName(), descriptor);
    }

    private void addDescriptorInternal(String registrationKey, JavaTypeDescriptor descriptor) {
        this.performInjections(descriptor);
        JavaTypeDescriptor old = this.descriptorsByName.put(registrationKey, descriptor);
        if (old != null && old != descriptor) {
            log.debugf("JavaTypeDescriptorRegistry entry replaced : %s -> %s (was %s)", descriptor.getJavaType(), (Object)descriptor, (Object)old);
        }
    }

    private void performInjections(JavaTypeDescriptor descriptor) {
        if (descriptor instanceof TypeConfigurationAware) {
            ((TypeConfigurationAware)((Object)descriptor)).setTypeConfiguration(this.typeConfiguration);
        }
    }

    private class OnTheFlySerializableJavaDescriptor<T extends Serializable>
    extends AbstractBasicJavaDescriptor<T> {
        private final SqlTypeDescriptor sqlTypeDescriptor;

        public OnTheFlySerializableJavaDescriptor(Class<T> type) {
            super(type);
            log.debugf("Could not find matching JavaTypeDescriptor for requested Java class [%s]; using fallback via its Serializable interface.  This means Hibernate does not know how to perform certain basic operations in relation to this Java typewhich can lead to those operations having a large performance impact.  Consider registering these JavaTypeDescriptors with the %s during bootstrap, either directly or through a registered %s accessing the %s ", new Object[]{this.getJavaType().getName(), JavaTypeDescriptorRegistry.class.getName(), TypeContributor.class.getName(), TypeConfiguration.class.getName()});
            this.sqlTypeDescriptor = VarbinarySqlDescriptor.INSTANCE;
        }

        @Override
        public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
            return this.sqlTypeDescriptor;
        }

        @Override
        public <X> X unwrap(T value, Class<X> type, SharedSessionContractImplementor session) {
            if (type.equals(byte[].class)) {
                throw new UnsupportedOperationException("Cannot unwrap Serializable to format other than byte[]");
            }
            return (X)SerializationHelper.serialize(value);
        }

        @Override
        public <X> T wrap(X value, SharedSessionContractImplementor session) {
            if (value == null) {
                return null;
            }
            if (value.getClass().equals(byte[].class)) {
                throw new UnsupportedOperationException("Cannot unwrap Serializable to format other than byte[]");
            }
            byte[] bytes = (byte[])value;
            return (T)((Serializable)SerializationHelper.deserialize(bytes));
        }
    }
}

