/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public abstract class MutableMutabilityPlan<T>
implements MutabilityPlan<T> {
    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Serializable disassemble(T value) {
        return (Serializable)this.deepCopy(value);
    }

    @Override
    public T assemble(Serializable cached) {
        return (T)this.deepCopy(cached);
    }

    @Override
    public final T deepCopy(T value) {
        return value == null ? null : (T)this.deepCopyNotNull(value);
    }

    @Override
    public T replace(Navigable<T> navigable, T originalValue, T targetValue, Object owner, Map copyCache, SessionImplementor session) {
        if (originalValue == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
            return targetValue;
        }
        return this.getReplacement(navigable, originalValue, targetValue);
    }

    @Override
    public T replace(Navigable<T> navigable, T originalValue, T targetValue, Object owner, Map copyCache, ForeignKeyDirection foreignKeyDirection, SessionImplementor session) {
        return ForeignKeyDirection.FROM_PARENT == foreignKeyDirection ? this.getReplacement(navigable, originalValue, targetValue) : targetValue;
    }

    protected T getReplacement(Navigable<T> navigable, T original, T target) {
        JavaTypeDescriptor javaTypeDescriptor = navigable.getJavaTypeDescriptor();
        if (!this.isMutable() || target != null && javaTypeDescriptor.areEqual(original, target)) {
            return original;
        }
        return this.deepCopy(original);
    }

    protected abstract T deepCopyNotNull(T var1);
}

