/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.internal;

import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.internal.BasicJdbcLiteralFormatter;

public class JdbcLiteralFormatterCharacterData
extends BasicJdbcLiteralFormatter {
    private final boolean isNationalized;

    public JdbcLiteralFormatterCharacterData(JavaTypeDescriptor javaTypeDescriptor) {
        this(javaTypeDescriptor, false);
    }

    public JdbcLiteralFormatterCharacterData(JavaTypeDescriptor javaTypeDescriptor, boolean isNationalized) {
        super(javaTypeDescriptor);
        this.isNationalized = isNationalized;
    }

    public String toJdbcLiteral(Object value, Dialect dialect, SharedSessionContractImplementor session) {
        String literalValue = this.unwrap(value, String.class, session);
        if (this.isNationalized) {
            return String.format(Locale.ROOT, "n'%s'", literalValue);
        }
        return String.format(Locale.ROOT, "'%s'", literalValue);
    }
}

