/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.internal;

import java.sql.Time;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.TemporalType;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.internal.DateTimeUtils;
import org.hibernate.type.descriptor.java.spi.TemporalJavaDescriptor;
import org.hibernate.type.descriptor.sql.internal.BasicJdbcLiteralFormatter;

public class JdbcLiteralFormatterTemporal
extends BasicJdbcLiteralFormatter {
    private final TemporalType precision;

    public JdbcLiteralFormatterTemporal(TemporalJavaDescriptor javaTypeDescriptor, TemporalType precision) {
        super(javaTypeDescriptor);
        this.precision = precision;
    }

    @Override
    protected TemporalJavaDescriptor getJavaTypeDescriptor() {
        return (TemporalJavaDescriptor)super.getJavaTypeDescriptor();
    }

    public String toJdbcLiteral(Object value, Dialect dialect, SharedSessionContractImplementor session) {
        if (value instanceof Date) {
            return DateTimeUtils.formatJdbcLiteralUsingPrecision((Date)value, this.precision);
        }
        if (value instanceof Calendar) {
            return DateTimeUtils.formatJdbcLiteralUsingPrecision((Calendar)value, this.precision);
        }
        if (value instanceof TemporalAccessor) {
            return DateTimeUtils.formatJdbcLiteralUsingPrecision((TemporalAccessor)value, this.precision);
        }
        switch (this.getJavaTypeDescriptor().getPrecision()) {
            case DATE: {
                return DateTimeUtils.formatJdbcLiteralUsingPrecision(this.unwrap(value, java.sql.Date.class, session), this.precision);
            }
            case TIME: {
                return DateTimeUtils.formatJdbcLiteralUsingPrecision(this.unwrap(value, Time.class, session), this.precision);
            }
        }
        return DateTimeUtils.formatJdbcLiteralUsingPrecision(this.unwrap(value, Date.class, session), this.precision);
    }
}

