/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.spi;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.sql.AbstractJdbcValueBinder;
import org.hibernate.sql.AbstractJdbcValueExtractor;
import org.hibernate.sql.JdbcValueBinder;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.AbstractTemplateSqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.JdbcLiteralFormatter;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class BlobSqlDescriptor
extends AbstractTemplateSqlTypeDescriptor {
    public static final BlobSqlDescriptor BLOB_BINDING = new BlobSqlDescriptor(){

        @Override
        public <T> BasicJavaDescriptor<T> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
            return (BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(Blob.class);
        }

        @Override
        public <X> JdbcValueBinder<X> createBinder(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return new AbstractJdbcValueBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, int index, X value, ExecutionContext executionContext) throws SQLException {
                    if (executionContext.getSession().useStreamForLobBinding()) {
                        st.setBlob(index, javaTypeDescriptor.unwrap(value, InputStream.class, executionContext.getSession()));
                    } else {
                        st.setBlob(index, javaTypeDescriptor.unwrap(value, Blob.class, executionContext.getSession()));
                    }
                }

                @Override
                protected void doBind(CallableStatement st, String name, X value, ExecutionContext executionContext) throws SQLException {
                    if (executionContext.getSession().useStreamForLobBinding()) {
                        st.setBlob(name, javaTypeDescriptor.unwrap(value, InputStream.class, executionContext.getSession()));
                    } else {
                        st.setBlob(name, javaTypeDescriptor.unwrap(value, Blob.class, executionContext.getSession()));
                    }
                }
            };
        }
    };
    public static final BlobSqlDescriptor PRIMITIVE_ARRAY_BINDING = new BlobSqlDescriptor(){

        @Override
        public <T> BasicJavaDescriptor<T> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
            return (BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(byte[].class);
        }

        @Override
        public <X> JdbcValueBinder<X> createBinder(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return new AbstractJdbcValueBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, int index, X value, ExecutionContext executionContext) throws SQLException {
                    st.setBytes(index, javaTypeDescriptor.unwrap(value, byte[].class, executionContext.getSession()));
                }

                @Override
                protected void doBind(CallableStatement st, String name, X value, ExecutionContext executionContext) throws SQLException {
                    st.setBytes(name, javaTypeDescriptor.unwrap(value, byte[].class, executionContext.getSession()));
                }
            };
        }
    };
    public static final BlobSqlDescriptor STREAM_BINDING = new BlobSqlDescriptor(){

        @Override
        public <T> BasicJavaDescriptor<T> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
            return null;
        }

        @Override
        public <X> JdbcValueBinder<X> createBinder(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return new AbstractJdbcValueBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, int index, X value, ExecutionContext executionContext) throws SQLException {
                    BinaryStream binaryStream = javaTypeDescriptor.unwrap(value, BinaryStream.class, executionContext.getSession());
                    st.setBinaryStream(index, binaryStream.getInputStream(), binaryStream.getLength());
                }

                @Override
                protected void doBind(CallableStatement st, String name, X value, ExecutionContext executionContext) throws SQLException {
                    BinaryStream binaryStream = javaTypeDescriptor.unwrap(value, BinaryStream.class, executionContext.getSession());
                    st.setBinaryStream(name, binaryStream.getInputStream(), binaryStream.getLength());
                }
            };
        }
    };
    public static final BlobSqlDescriptor DEFAULT = BLOB_BINDING;

    private BlobSqlDescriptor() {
    }

    @Override
    public int getJdbcTypeCode() {
        return 2004;
    }

    @Override
    public boolean canBeRemapped() {
        return true;
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaTypeDescriptor<T> javaTypeDescriptor) {
        return null;
    }

    @Override
    protected <X> JdbcValueExtractor<X> createExtractor(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new AbstractJdbcValueExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, int position, ExecutionContext executionContext) throws SQLException {
                return javaTypeDescriptor.wrap(rs.getBlob(position), executionContext.getSession());
            }

            @Override
            protected X doExtract(CallableStatement statement, int position, ExecutionContext executionContext) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getBlob(position), executionContext.getSession());
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, ExecutionContext executionContext) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getBlob(name), executionContext.getSession());
            }
        };
    }

    @Override
    protected abstract <X> JdbcValueBinder<X> createBinder(BasicJavaDescriptor<X> var1, TypeConfiguration var2);
}

