/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.spi;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.sql.AbstractJdbcValueBinder;
import org.hibernate.sql.AbstractJdbcValueExtractor;
import org.hibernate.sql.JdbcValueBinder;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.internal.JdbcLiteralFormatterNumericData;
import org.hibernate.type.descriptor.sql.spi.AbstractTemplateSqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.JdbcLiteralFormatter;
import org.hibernate.type.spi.TypeConfiguration;

public class DoubleSqlDescriptor
extends AbstractTemplateSqlTypeDescriptor {
    public static final DoubleSqlDescriptor INSTANCE = new DoubleSqlDescriptor();

    @Override
    public int getJdbcTypeCode() {
        return 8;
    }

    @Override
    public boolean canBeRemapped() {
        return true;
    }

    @Override
    public <T> BasicJavaDescriptor<T> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
        return (BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(Double.class);
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaTypeDescriptor<T> javaTypeDescriptor) {
        return new JdbcLiteralFormatterNumericData(javaTypeDescriptor, Double.class);
    }

    @Override
    protected <X> JdbcValueBinder<X> createBinder(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new AbstractJdbcValueBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(PreparedStatement st, int index, X value, ExecutionContext executionContext) throws SQLException {
                st.setDouble(index, javaTypeDescriptor.unwrap(value, Double.class, executionContext.getSession()));
            }

            @Override
            protected void doBind(CallableStatement st, String name, X value, ExecutionContext executionContext) throws SQLException {
                st.setDouble(name, (double)javaTypeDescriptor.unwrap(value, Double.class, executionContext.getSession()));
            }
        };
    }

    @Override
    protected <X> JdbcValueExtractor<X> createExtractor(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new AbstractJdbcValueExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, int position, ExecutionContext executionContext) throws SQLException {
                return javaTypeDescriptor.wrap(rs.getDouble(position), executionContext.getSession());
            }

            @Override
            protected X doExtract(CallableStatement statement, int position, ExecutionContext executionContext) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getDouble(position), executionContext.getSession());
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, ExecutionContext executionContext) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getDouble(name), executionContext.getSession());
            }
        };
    }
}

