/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.spi;

import java.sql.CallableStatement;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.sql.AbstractJdbcValueBinder;
import org.hibernate.sql.AbstractJdbcValueExtractor;
import org.hibernate.sql.JdbcValueBinder;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.AbstractTemplateSqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.JdbcLiteralFormatter;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class NClobSqlDescriptor
extends AbstractTemplateSqlTypeDescriptor {
    public static final NClobSqlDescriptor NCLOB_BINDING = new NClobSqlDescriptor(){

        @Override
        public <T> BasicJavaDescriptor<T> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
            return (BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(NClob.class);
        }

        @Override
        protected <X> JdbcValueBinder<X> createBinder(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return new AbstractJdbcValueBinder(javaTypeDescriptor, this){

                protected void doBind(PreparedStatement st, int index, Object value, ExecutionContext executionContext) throws SQLException {
                    if (executionContext.getSession().useStreamForLobBinding()) {
                        st.setNClob(index, javaTypeDescriptor.unwrap(value, CharacterStream.class, executionContext.getSession()).asReader());
                    } else {
                        st.setNClob(index, javaTypeDescriptor.unwrap(value, NClob.class, executionContext.getSession()));
                    }
                }

                protected void doBind(CallableStatement st, String name, Object value, ExecutionContext executionContext) throws SQLException {
                    if (executionContext.getSession().useStreamForLobBinding()) {
                        st.setNClob(name, javaTypeDescriptor.unwrap(value, CharacterStream.class, executionContext.getSession()).asReader());
                    } else {
                        st.setNClob(name, javaTypeDescriptor.unwrap(value, NClob.class, executionContext.getSession()));
                    }
                }
            };
        }
    };
    public static final NClobSqlDescriptor STREAM_BINDING = new NClobSqlDescriptor(){

        @Override
        public <T> BasicJavaDescriptor<T> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
            return null;
        }

        @Override
        protected <X> JdbcValueBinder<X> createBinder(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return new AbstractJdbcValueBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, int index, X value, ExecutionContext executionContext) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(value, CharacterStream.class, executionContext.getSession());
                    st.setCharacterStream(index, characterStream.asReader(), characterStream.getLength());
                }

                @Override
                protected void doBind(CallableStatement st, String name, X value, ExecutionContext executionContext) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(value, CharacterStream.class, executionContext.getSession());
                    st.setCharacterStream(name, characterStream.asReader(), characterStream.getLength());
                }
            };
        }
    };
    public static final NClobSqlDescriptor DEFAULT = NCLOB_BINDING;

    @Override
    public int getJdbcTypeCode() {
        return 2011;
    }

    @Override
    public boolean canBeRemapped() {
        return true;
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaTypeDescriptor<T> javaTypeDescriptor) {
        return null;
    }

    @Override
    protected <X> JdbcValueExtractor<X> createExtractor(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new AbstractJdbcValueExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, int position, ExecutionContext executionContext) throws SQLException {
                return javaTypeDescriptor.wrap(rs.getNClob(position), executionContext.getSession());
            }

            @Override
            protected X doExtract(CallableStatement statement, int position, ExecutionContext executionContext) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getNClob(position), executionContext.getSession());
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, ExecutionContext executionContext) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getNClob(name), executionContext.getSession());
            }
        };
    }
}

