/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.spi;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.sql.AbstractJdbcValueBinder;
import org.hibernate.sql.AbstractJdbcValueExtractor;
import org.hibernate.sql.JdbcValueBinder;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.internal.JdbcLiteralFormatterNumericData;
import org.hibernate.type.descriptor.sql.spi.AbstractTemplateSqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.JdbcLiteralFormatter;
import org.hibernate.type.spi.TypeConfiguration;

public class SmallIntSqlDescriptor
extends AbstractTemplateSqlTypeDescriptor {
    public static final SmallIntSqlDescriptor INSTANCE = new SmallIntSqlDescriptor();

    @Override
    public int getJdbcTypeCode() {
        return 5;
    }

    @Override
    public boolean canBeRemapped() {
        return true;
    }

    @Override
    public <T> BasicJavaDescriptor<T> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
        return (BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(Short.class);
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaTypeDescriptor<T> javaTypeDescriptor) {
        return new JdbcLiteralFormatterNumericData(javaTypeDescriptor, Short.class);
    }

    @Override
    protected <X> JdbcValueBinder<X> createBinder(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new AbstractJdbcValueBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(PreparedStatement st, int index, X value, ExecutionContext executionContext) throws SQLException {
                st.setShort(index, javaTypeDescriptor.unwrap(value, Short.class, executionContext.getSession()));
            }

            @Override
            protected void doBind(CallableStatement st, String name, X value, ExecutionContext executionContext) throws SQLException {
                st.setShort(name, (short)javaTypeDescriptor.unwrap(value, Short.class, executionContext.getSession()));
            }
        };
    }

    @Override
    protected <X> JdbcValueExtractor<X> createExtractor(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new AbstractJdbcValueExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, int position, ExecutionContext executionContext) throws SQLException {
                return javaTypeDescriptor.wrap(rs.getShort(position), executionContext.getSession());
            }

            @Override
            protected X doExtract(CallableStatement statement, int position, ExecutionContext executionContext) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getShort(position), executionContext.getSession());
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, ExecutionContext executionContext) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getShort(name), executionContext.getSession());
            }
        };
    }
}

