/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.spi;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.sql.AbstractJdbcValueBinder;
import org.hibernate.sql.AbstractJdbcValueExtractor;
import org.hibernate.sql.JdbcValueBinder;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.internal.SqlTypeDescriptorBaseline;
import org.hibernate.type.descriptor.sql.spi.AbstractTemplateSqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.sql.spi.JdbcTypeFamilyInformation;
import org.hibernate.type.descriptor.sql.spi.JdbcTypeNameMapper;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.VarbinarySqlDescriptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class SqlTypeDescriptorRegistry
implements SqlTypeDescriptorBaseline.BaselineTarget {
    private static final Logger log = Logger.getLogger(SqlTypeDescriptorRegistry.class);
    private ConcurrentHashMap<Integer, SqlTypeDescriptor> descriptorMap = new ConcurrentHashMap();

    public SqlTypeDescriptorRegistry(TypeConfiguration typeConfiguration) {
        SqlTypeDescriptorBaseline.prime(this);
    }

    @Override
    public void addDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        this.descriptorMap.put(sqlTypeDescriptor.getJdbcTypeCode(), sqlTypeDescriptor);
    }

    public SqlTypeDescriptor getDescriptor(int jdbcTypeCode) {
        JdbcTypeFamilyInformation.Family family;
        SqlTypeDescriptor descriptor = this.descriptorMap.get(jdbcTypeCode);
        if (descriptor != null) {
            return descriptor;
        }
        if (JdbcTypeNameMapper.isStandardTypeCode(jdbcTypeCode)) {
            log.debugf("A standard JDBC type code [%s] was not defined in SqlTypeDescriptorRegistry", jdbcTypeCode);
        }
        if ((family = JdbcTypeFamilyInformation.INSTANCE.locateJdbcTypeFamilyByTypeCode(jdbcTypeCode)) != null) {
            for (int potentialAlternateTypeCode : family.getTypeCodes()) {
                if (potentialAlternateTypeCode == jdbcTypeCode) continue;
                SqlTypeDescriptor potentialAlternateDescriptor = this.descriptorMap.get(potentialAlternateTypeCode);
                if (potentialAlternateDescriptor != null) {
                    return potentialAlternateDescriptor;
                }
                if (!JdbcTypeNameMapper.isStandardTypeCode(potentialAlternateTypeCode)) continue;
                log.debugf("A standard JDBC type code [%s] was not defined in SqlTypeDescriptorRegistry", potentialAlternateTypeCode);
            }
        }
        ObjectSqlTypeDescriptor fallBackDescriptor = new ObjectSqlTypeDescriptor(jdbcTypeCode);
        this.addDescriptor(fallBackDescriptor);
        return fallBackDescriptor;
    }

    public boolean hasRegisteredDescriptor(int jdbcTypeCode) {
        return this.descriptorMap.containsKey(jdbcTypeCode) || JdbcTypeNameMapper.isStandardTypeCode(jdbcTypeCode) || JdbcTypeFamilyInformation.INSTANCE.locateJdbcTypeFamilyByTypeCode(jdbcTypeCode) != null;
    }

    public static class ObjectSqlTypeDescriptor
    extends AbstractTemplateSqlTypeDescriptor {
        private final int jdbcTypeCode;

        public ObjectSqlTypeDescriptor(int jdbcTypeCode) {
            this.jdbcTypeCode = jdbcTypeCode;
        }

        @Override
        public int getJdbcTypeCode() {
            return this.jdbcTypeCode;
        }

        @Override
        public <T> BasicJavaDescriptor<T> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
            throw new UnsupportedOperationException("No recommended Java-type mapping known for JDBC type code [" + this.jdbcTypeCode + "]");
        }

        @Override
        public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaTypeDescriptor<T> javaTypeDescriptor) {
            return null;
        }

        @Override
        public boolean canBeRemapped() {
            return true;
        }

        @Override
        public <X> JdbcValueBinder<X> createBinder(BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            if (Serializable.class.isAssignableFrom(javaTypeDescriptor.getJavaType())) {
                return VarbinarySqlDescriptor.INSTANCE.getSqlExpressableType((BasicJavaDescriptor)javaTypeDescriptor, typeConfiguration).getJdbcValueBinder();
            }
            return new AbstractJdbcValueBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, int index, X value, ExecutionContext executionContext) throws SQLException {
                    st.setObject(index, value, jdbcTypeCode);
                }

                @Override
                protected void doBind(CallableStatement st, String name, X value, ExecutionContext executionContext) throws SQLException {
                    st.setObject(name, value, jdbcTypeCode);
                }
            };
        }

        @Override
        public <X> JdbcValueExtractor<X> createExtractor(BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            if (Serializable.class.isAssignableFrom(javaTypeDescriptor.getJavaType())) {
                return VarbinarySqlDescriptor.INSTANCE.getSqlExpressableType((BasicJavaDescriptor)javaTypeDescriptor, typeConfiguration).getJdbcValueExtractor();
            }
            return new AbstractJdbcValueExtractor<X>(javaTypeDescriptor, this){

                @Override
                protected X doExtract(ResultSet rs, int position, ExecutionContext executionContext) throws SQLException {
                    return rs.getObject(position);
                }

                @Override
                protected X doExtract(CallableStatement statement, int position, ExecutionContext executionContext) throws SQLException {
                    return statement.getObject(position);
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, ExecutionContext executionContext) throws SQLException {
                    return statement.getObject(name);
                }
            };
        }
    }
}

