/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.sql.JdbcValueBinder;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.BasicType;
import org.hibernate.type.ProcedureParameterNamedBinder;

public class BasicTypeBinderAdapter<T>
implements JdbcValueBinder<T> {
    private final BasicType basicType;
    private final boolean canBindToCallable;

    public BasicTypeBinderAdapter(BasicType basicType) {
        this.basicType = basicType;
        this.canBindToCallable = basicType instanceof ProcedureParameterNamedBinder;
    }

    @Override
    public void bind(PreparedStatement statement, int parameterPosition, T value, ExecutionContext executionContext) throws SQLException {
        this.basicType.nullSafeSet(statement, value, parameterPosition, executionContext.getSession());
    }

    @Override
    public void bind(CallableStatement statement, String parameterName, T value, ExecutionContext executionContext) throws SQLException {
        if (!this.canBindToCallable) {
            throw new UnsupportedOperationException("BasicType [" + this.basicType.getClass().getName() + "] does not implement " + ProcedureParameterNamedBinder.class.getName() + ", cannot bind to JDBC CallableStatement");
        }
        ((ProcedureParameterNamedBinder)((Object)this.basicType)).nullSafeSet(statement, value, parameterName, executionContext.getSession());
    }
}

