/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.BasicType;
import org.hibernate.type.ProcedureParameterExtractionAware;

public class BasicTypeExtractorAdaptor<T>
implements JdbcValueExtractor<T> {
    private final BasicType basicType;
    private final boolean canExtractFromCallable;

    public BasicTypeExtractorAdaptor(BasicType basicType) {
        this.basicType = basicType;
        this.canExtractFromCallable = basicType instanceof ProcedureParameterExtractionAware;
    }

    @Override
    public T extract(ResultSet resultSet, int jdbcParameterPosition, ExecutionContext executionContext) throws SQLException {
        return (T)this.basicType.nullSafeGet(resultSet, jdbcParameterPosition, executionContext.getSession());
    }

    @Override
    public T extract(CallableStatement statement, int jdbcParameterPosition, ExecutionContext executionContext) throws SQLException {
        if (this.canExtractFromCallable) {
            return ((ProcedureParameterExtractionAware)((Object)this.basicType)).extract(statement, jdbcParameterPosition, executionContext.getSession());
        }
        throw new UnsupportedOperationException("BasicType [" + this.basicType.getClass().getName() + "] does not implement " + ProcedureParameterExtractionAware.class.getName() + ", cannot extract values from CallableStatement");
    }

    @Override
    public T extract(CallableStatement statement, String jdbcParameterName, ExecutionContext executionContext) throws SQLException {
        if (this.canExtractFromCallable) {
            return ((ProcedureParameterExtractionAware)((Object)this.basicType)).extract(statement, jdbcParameterName, executionContext.getSession());
        }
        throw new UnsupportedOperationException("BasicType [" + this.basicType.getClass().getName() + "] does not implement " + ProcedureParameterExtractionAware.class.getName() + ", cannot extract values from CallableStatement");
    }
}

