/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.util.function.Consumer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class BasicTypeImpl<T>
implements BasicType<T> {
    private final BasicJavaDescriptor javaDescriptor;
    private final SqlTypeDescriptor sqlTypeDescriptor;
    private final SqlExpressableType sqlExpressableType;

    public BasicTypeImpl(BasicJavaDescriptor javaDescriptor, SqlTypeDescriptor sqlTypeDescriptor, TypeConfiguration typeConfiguration) {
        this(javaDescriptor, sqlTypeDescriptor, sqlTypeDescriptor.getSqlExpressableType(javaDescriptor, typeConfiguration));
    }

    public BasicTypeImpl(BasicJavaDescriptor javaDescriptor, SqlTypeDescriptor sqlTypeDescriptor, SqlExpressableType sqlExpressableType) {
        this.javaDescriptor = javaDescriptor;
        this.sqlTypeDescriptor = sqlTypeDescriptor;
        this.sqlExpressableType = sqlExpressableType;
    }

    @Override
    public BasicJavaDescriptor<T> getJavaTypeDescriptor() {
        return this.javaDescriptor;
    }

    @Override
    public SqlTypeDescriptor getSqlTypeDescriptor() {
        return this.sqlTypeDescriptor;
    }

    @Override
    public SqlExpressableType getSqlExpressableType() {
        return this.sqlExpressableType;
    }

    @Override
    public void visitJdbcTypes(Consumer<SqlExpressableType> action, Clause clause, TypeConfiguration typeConfiguration) {
        action.accept(this.getSqlExpressableType());
    }

    @Override
    public Object unresolve(Object value, SharedSessionContractImplementor session) {
        return value;
    }
}

