/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.type.BasicType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;

public class BasicTypeMutabilityPlanAdapter<T>
implements MutabilityPlan<T> {
    private final BasicType basicType;

    public BasicTypeMutabilityPlanAdapter(BasicType basicType) {
        this.basicType = basicType;
    }

    @Override
    public boolean isMutable() {
        return this.basicType.isMutable();
    }

    @Override
    public T deepCopy(T value) {
        return (T)this.basicType.deepCopy(value);
    }

    @Override
    public Serializable disassemble(T value) {
        return this.basicType.disassemble(value);
    }

    @Override
    public T assemble(Serializable cached) {
        return (T)this.basicType.assemble(cached);
    }

    @Override
    public T replace(Navigable<T> navigable, T originalValue, T targetValue, Object owner, Map copyCache, SessionImplementor session) {
        if (originalValue == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
            return targetValue;
        }
        return this.getReplacement(originalValue, targetValue);
    }

    @Override
    public T replace(Navigable<T> navigable, T originalValue, T targetValue, Object owner, Map copyCache, ForeignKeyDirection foreignKeyDirection, SessionImplementor session) {
        return ForeignKeyDirection.FROM_PARENT == foreignKeyDirection ? this.getReplacement(originalValue, targetValue) : targetValue;
    }

    protected T getReplacement(T original, T target) {
        BasicJavaDescriptor javaTypeDescriptor = this.basicType.getJavaTypeDescriptor();
        if (!this.isMutable() || target != null && javaTypeDescriptor.areEqual(original, target)) {
            return original;
        }
        return this.deepCopy(original);
    }
}

