/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import org.hibernate.boot.model.domain.BasicValueMapping;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.spi.BasicValueMapper;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.internal.BasicTypeAdapter;
import org.hibernate.type.internal.BasicTypeMutabilityPlanAdapter;

public class BasicTypeResolution<J>
implements BasicValueMapping.Resolution<J>,
BasicValueMapper<J> {
    private final BasicTypeAdapter basicTypeAdapter;
    private final MutabilityPlan mutabilityPlan;

    public BasicTypeResolution(BasicTypeAdapter basicTypeAdapter, MutabilityPlan mutabilityPlan) {
        this.basicTypeAdapter = basicTypeAdapter;
        this.mutabilityPlan = mutabilityPlan;
    }

    public BasicTypeResolution(BasicType basicType, String name, BasicJavaDescriptor explicitJtd, SqlTypeDescriptor explicitStd, MutabilityPlan explicitMutabilityPlan, MetadataBuildingContext context) {
        this.basicTypeAdapter = new BasicTypeAdapter(basicType, name, explicitJtd, explicitStd, context);
        this.mutabilityPlan = explicitMutabilityPlan != null ? explicitMutabilityPlan : new BasicTypeMutabilityPlanAdapter(basicType);
    }

    @Override
    public BasicJavaDescriptor<J> getDomainJavaDescriptor() {
        return this.basicTypeAdapter.getJavaTypeDescriptor();
    }

    @Override
    public BasicJavaDescriptor<?> getRelationalJavaDescriptor() {
        return this.basicTypeAdapter.getJavaTypeDescriptor();
    }

    @Override
    public SqlTypeDescriptor getRelationalSqlTypeDescriptor() {
        return this.basicTypeAdapter.getSqlTypeDescriptor();
    }

    @Override
    public BasicValueConverter getValueConverter() {
        return null;
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public org.hibernate.type.spi.BasicType getBasicType() {
        return this.basicTypeAdapter;
    }

    @Override
    public SqlExpressableType getSqlExpressableType() {
        return this.basicTypeAdapter.getSqlExpressableType();
    }

    @Override
    public BasicValueMapper<J> getValueMapper() {
        return this;
    }
}

