/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.util.function.Function;
import org.hibernate.boot.model.domain.BasicValueMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.internal.InferredBasicValueResolution;
import org.hibernate.type.spi.TypeConfiguration;

public class InferredBasicValueResolver<J> {
    private final TypeConfiguration typeConfiguration;
    private BasicJavaDescriptor<J> domainJtd;
    private BasicJavaDescriptor<?> relationalJtd;
    private SqlTypeDescriptor relationalStd;
    private BasicValueConverter valueConverter;
    private MutabilityPlan<J> mutabilityPlan;

    public InferredBasicValueResolver(Function<TypeConfiguration, BasicJavaDescriptor<J>> explicitJtdAccess, Function<TypeConfiguration, SqlTypeDescriptor> explicitStdAccess, TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
        this.domainJtd = explicitJtdAccess != null ? explicitJtdAccess.apply(typeConfiguration) : null;
        this.relationalStd = explicitStdAccess != null ? explicitStdAccess.apply(typeConfiguration) : null;
    }

    public BasicValueMapping.Resolution<J> build() {
        BasicTypeImpl basicType = new BasicTypeImpl(this.relationalJtd, this.relationalStd, this.relationalStd.getSqlExpressableType(this.relationalJtd, this.typeConfiguration));
        return new InferredBasicValueResolution(basicType, this.domainJtd, this.valueConverter, this.mutabilityPlan);
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public BasicJavaDescriptor<?> getDomainJtd() {
        return this.domainJtd;
    }

    public void setDomainJtd(BasicJavaDescriptor domainJtd) {
        this.domainJtd = domainJtd;
    }

    public BasicJavaDescriptor<?> getRelationalJtd() {
        return this.relationalJtd;
    }

    public void setRelationalJtd(BasicJavaDescriptor<?> relationalJtd) {
        this.relationalJtd = relationalJtd;
    }

    public SqlTypeDescriptor getRelationalStd() {
        return this.relationalStd;
    }

    public void setRelationalStd(SqlTypeDescriptor relationalStd) {
        this.relationalStd = relationalStd;
    }

    public BasicValueConverter getValueConverter() {
        return this.valueConverter;
    }

    public void setValueConverter(BasicValueConverter valueConverter) {
        this.valueConverter = valueConverter;
    }

    public MutabilityPlan getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    public void setMutabilityPlan(MutabilityPlan mutabilityPlan) {
        this.mutabilityPlan = mutabilityPlan;
    }
}

