/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.metamodel.model.domain.spi.BasicValueMapper;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class NamedConverterMapper
implements BasicValueMapper {
    private final String name;
    private final BasicJavaDescriptor domainJtd;
    private final SqlExpressableType sqlExpressableType;
    private final JpaAttributeConverter jpaAttributeConverter;
    private final MutabilityPlan mutabilityPlan;

    public static BasicValueMapper from(String name, BasicJavaDescriptor explicitJtd, SqlTypeDescriptor explicitStd, JpaAttributeConverterCreationContext converterCreationContext, MutabilityPlan explicitMutabilityPlan, SqlTypeDescriptorIndicators sqlTypeIndicators, MetadataBuildingContext metadataBuildingContext) {
        StandardServiceRegistry serviceRegistry = metadataBuildingContext.getBootstrapContext().getServiceRegistry();
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        TypeConfiguration typeConfiguration = metadataBuildingContext.getBootstrapContext().getTypeConfiguration();
        String converterClassName = name.substring("converted::".length());
        Class converterClass = classLoaderService.classForName(converterClassName);
        ClassBasedConverterDescriptor converterDescriptor = new ClassBasedConverterDescriptor(converterClass, metadataBuildingContext.getBootstrapContext().getClassmateContext());
        JpaAttributeConverter converter = converterDescriptor.createJpaAttributeConverter(converterCreationContext);
        BasicJavaDescriptor domainJtd = explicitJtd != null ? explicitJtd : converter.getDomainJavaDescriptor();
        BasicJavaDescriptor relationalJtd = converter.getRelationalJavaDescriptor();
        SqlTypeDescriptor relationalStd = explicitStd != null ? explicitStd : relationalJtd.getJdbcRecommendedSqlType(sqlTypeIndicators);
        return new NamedConverterMapper(name, domainJtd, relationalStd.getSqlExpressableType(relationalJtd, typeConfiguration), converter, explicitMutabilityPlan != null ? explicitMutabilityPlan : converter.getDomainJavaDescriptor().getMutabilityPlan());
    }

    public NamedConverterMapper(String name, BasicJavaDescriptor domainJtd, SqlExpressableType sqlExpressableType, JpaAttributeConverter jpaAttributeConverter, MutabilityPlan mutabilityPlan) {
        this.name = name;
        this.domainJtd = domainJtd;
        this.sqlExpressableType = sqlExpressableType;
        this.jpaAttributeConverter = jpaAttributeConverter;
        this.mutabilityPlan = mutabilityPlan;
    }

    public BasicJavaDescriptor<?> getDomainJavaDescriptor() {
        return this.domainJtd;
    }

    @Override
    public SqlExpressableType getSqlExpressableType() {
        return this.sqlExpressableType;
    }

    @Override
    public BasicValueConverter getValueConverter() {
        return this.jpaAttributeConverter;
    }

    public MutabilityPlan getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    public String toString() {
        return "NamedConverterResolution(" + this.name + ')';
    }
}

