/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.util.function.Consumer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.StandardSpiBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class StandardBasicTypeImpl<J>
implements StandardSpiBasicTypes.StandardBasicType<J> {
    private final BasicJavaDescriptor domainJtd;
    private final BasicJavaDescriptor relationalJtd;
    private final SqlTypeDescriptor relationalStd;
    private final BasicValueConverter valueConverter;
    private final MutabilityPlan mutabilityPlan;

    public StandardBasicTypeImpl(BasicJavaDescriptor<J> jtd, SqlTypeDescriptor std) {
        this(jtd, jtd, std, null, jtd.getMutabilityPlan());
    }

    public StandardBasicTypeImpl(BasicJavaDescriptor<J> jtd, SqlTypeDescriptor std, MutabilityPlan<J> mutabilityPlan) {
        this(jtd, jtd, std, null, jtd.getMutabilityPlan());
    }

    public StandardBasicTypeImpl(BasicJavaDescriptor<J> domainJtd, BasicJavaDescriptor<?> relationalJtd, SqlTypeDescriptor std, BasicValueConverter<J, ?> valueConverter) {
        this(domainJtd, relationalJtd, std, valueConverter, null);
    }

    public StandardBasicTypeImpl(BasicJavaDescriptor domainJtd, BasicJavaDescriptor relationalJtd, SqlTypeDescriptor relationalStd, BasicValueConverter valueConverter, MutabilityPlan mutabilityPlan) {
        this.domainJtd = domainJtd;
        this.relationalJtd = relationalJtd;
        this.relationalStd = relationalStd;
        this.valueConverter = valueConverter;
        this.mutabilityPlan = mutabilityPlan;
    }

    @Override
    public BasicJavaDescriptor<J> getDomainJavaTypeDescriptor() {
        return this.domainJtd;
    }

    @Override
    public BasicJavaDescriptor getRelationalJavaTypeDescriptor() {
        return this.relationalJtd;
    }

    @Override
    public SqlTypeDescriptor getRelationalSqlTypeDescriptor() {
        return this.relationalStd;
    }

    @Override
    public BasicValueConverter<J, ?> getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public BasicJavaDescriptor<J> getJavaTypeDescriptor() {
        return this.getDomainJavaTypeDescriptor();
    }

    @Override
    public SqlTypeDescriptor getSqlTypeDescriptor() {
        return this.relationalStd;
    }

    @Override
    public SqlExpressableType getSqlExpressableType() {
        return null;
    }

    @Override
    public Object unresolve(Object value, SharedSessionContractImplementor session) {
        Object result = value;
        if (this.valueConverter != null) {
            result = this.valueConverter.toRelationalValue(value, session);
        }
        return result;
    }

    @Override
    public void dehydrate(Object value, Writeable.JdbcValueCollector jdbcValueCollector, Clause clause, SharedSessionContractImplementor session) {
        jdbcValueCollector.collect(value, this.resolveJdbcMapping(session.getFactory().getTypeConfiguration()), null);
    }

    private SqlExpressableType resolveJdbcMapping(TypeConfiguration typeConfiguration) {
        return typeConfiguration.resolveStandardBasicType(this).getSqlExpressableType(typeConfiguration);
    }

    @Override
    public void visitJdbcTypes(Consumer<SqlExpressableType> action, Clause clause, TypeConfiguration typeConfiguration) {
        action.accept(this.resolveJdbcMapping(typeConfiguration));
    }

    @Override
    public int getNumberOfJdbcParametersNeeded() {
        return 1;
    }
}

