/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.model.domain.spi.EmbeddedValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributor;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.type.ForeignKeyDirection;

public class TypeHelper {
    public static final BiFunction<StateArrayContributor, Object, Object> DEEP_COPY_VALUE_PRODUCER = new BiFunction<StateArrayContributor, Object, Object>(){

        @Override
        public Object apply(StateArrayContributor navigable, Object sourceValue) {
            if (sourceValue == LazyPropertyInitializer.UNFETCHED_PROPERTY || sourceValue == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
                return sourceValue;
            }
            return navigable.getMutabilityPlan().deepCopy(sourceValue);
        }
    };

    public static void deepCopy(ManagedTypeDescriptor containerDescriptor, Object[] source, Object[] target, Predicate<StateArrayContributor> copyConditions) {
        TypeHelper.deepCopy(containerDescriptor, source, target, copyConditions, DEEP_COPY_VALUE_PRODUCER);
    }

    public static void deepCopy(ManagedTypeDescriptor<?> containerDescriptor, Object[] source, Object[] target, Predicate<StateArrayContributor> copyConditions, BiFunction<StateArrayContributor, Object, Object> targetValueProducer) {
        for (StateArrayContributor contributor : containerDescriptor.getStateArrayContributors()) {
            if (!copyConditions.test(contributor)) continue;
            int position = contributor.getStateArrayPosition();
            target[position] = targetValueProducer.apply(contributor, source[position]);
        }
    }

    public static String toLoggableString(Object[] state, ManagedTypeDescriptor<?> managedTypeDescriptor) {
        StringBuilder buffer = new StringBuilder(managedTypeDescriptor.getNavigableName() + '[');
        boolean firstTime = true;
        for (StateArrayContributor contributor : managedTypeDescriptor.getStateArrayContributors()) {
            if (firstTime) {
                firstTime = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(contributor.getJavaTypeDescriptor().toString(state[contributor.getStateArrayPosition()]));
        }
        return buffer.append(']').toString();
    }

    public static Serializable[] disassemble(Object[] state, boolean[] nonCacheable, ManagedTypeDescriptor<?> containerDescriptor) {
        Serializable[] disassembledState = new Serializable[state.length];
        for (StateArrayContributor contributor : containerDescriptor.getStateArrayContributors()) {
            int position = contributor.getStateArrayPosition();
            if (nonCacheable != null && nonCacheable[position]) {
                disassembledState[position] = LazyPropertyInitializer.UNFETCHED_PROPERTY;
                continue;
            }
            if (state[position] == LazyPropertyInitializer.UNFETCHED_PROPERTY || state[position] == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
                disassembledState[position] = (Serializable)state[position];
                continue;
            }
            disassembledState[position] = contributor.getMutabilityPlan().disassemble(state[position]);
        }
        return disassembledState;
    }

    public static Object[] assemble(Serializable[] disassembledState, ManagedTypeDescriptor<?> containerDescriptor) {
        Object[] assembledProps = new Object[disassembledState.length];
        for (StateArrayContributor contributor : containerDescriptor.getStateArrayContributors()) {
            int position = contributor.getStateArrayPosition();
            if (disassembledState[position] == LazyPropertyInitializer.UNFETCHED_PROPERTY || disassembledState[position] == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
                assembledProps[position] = disassembledState[position];
                continue;
            }
            assembledProps[position] = contributor.getJavaTypeDescriptor().getMutabilityPlan().assemble(disassembledState[position]);
        }
        return assembledProps;
    }

    public static Object[] replace(ManagedTypeDescriptor<?> managedTypeDescriptor, Object original, Object target, Object owner, Map copyCache, SessionImplementor session) {
        List contributors = managedTypeDescriptor.getStateArrayContributors();
        Object[] originalValues = original == null ? new Object[contributors.size()] : managedTypeDescriptor.getPropertyValues(original);
        Object[] targetValues = target == null ? new Object[contributors.size()] : managedTypeDescriptor.getPropertyValues(target);
        Object[] copied = new Object[originalValues.length];
        for (StateArrayContributor contributor : contributors) {
            int position = contributor.getStateArrayPosition();
            if (originalValues[position] == LazyPropertyInitializer.UNFETCHED_PROPERTY || originalValues[position] == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
                copied[position] = targetValues[position];
                continue;
            }
            if (targetValues[position] == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                copied[position] = contributor.replace(originalValues[position], null, owner, copyCache, session);
                continue;
            }
            copied[position] = contributor.replace(originalValues[position], targetValues[position], owner, copyCache, session);
        }
        return copied;
    }

    public static Object[] replace(ManagedTypeDescriptor<?> managedTypeDescriptor, Object original, Object target, Object owner, Map copyCache, ForeignKeyDirection foreignKeyDirection, SessionImplementor session) {
        List contributors = managedTypeDescriptor.getStateArrayContributors();
        Object[] originalValues = original == null ? new Object[contributors.size()] : managedTypeDescriptor.getPropertyValues(original);
        Object[] targetValues = target == null ? new Object[contributors.size()] : managedTypeDescriptor.getPropertyValues(target);
        Object[] copied = new Object[originalValues.length];
        for (StateArrayContributor contributor : contributors) {
            int position = contributor.getStateArrayPosition();
            if (originalValues[position] == LazyPropertyInitializer.UNFETCHED_PROPERTY || originalValues[position] == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
                copied[position] = targetValues[position];
                continue;
            }
            if (targetValues[position] == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                copied[position] = contributor.replace(originalValues[position], null, owner, copyCache, foreignKeyDirection, session);
                continue;
            }
            copied[position] = contributor.replace(originalValues[position], targetValues[position], owner, copyCache, foreignKeyDirection, session);
        }
        return copied;
    }

    public static Object[] replace(EntityTypeDescriptor<?> entityDescriptor, Object originalEntity, Object targetEntity, Map copyCache, Object owner, SessionImplementor session) {
        Object[] originalValues = entityDescriptor.getPropertyValues(originalEntity);
        Object[] targetValues = entityDescriptor.getPropertyValues(targetEntity);
        Object[] copied = new Object[originalValues.length];
        for (StateArrayContributor contributor : entityDescriptor.getStateArrayContributors()) {
            int position = contributor.getStateArrayPosition();
            if (originalValues[position] == LazyPropertyInitializer.UNFETCHED_PROPERTY || originalValues[position] == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
                copied[position] = targetValues[position];
                continue;
            }
            if (targetValues[position] == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                if (contributor.getMutabilityPlan().isMutable()) {
                    copied[position] = contributor.getMutabilityPlan().deepCopy(originalValues[position]);
                    continue;
                }
                copied[position] = originalValues[position];
                continue;
            }
            copied[position] = contributor.replace(originalValues[position], targetValues[position], owner, copyCache, session);
        }
        return copied;
    }

    public static Object[] replace(EntityTypeDescriptor<?> entityDescriptor, Object originalEntity, Object targetEntity, Map copyCache, Object owner, ForeignKeyDirection foreignKeyDirection, SessionImplementor session) {
        Object[] originalValues = entityDescriptor.getPropertyValues(originalEntity);
        Object[] targetValues = entityDescriptor.getPropertyValues(targetEntity);
        Object[] copied = new Object[originalValues.length];
        for (StateArrayContributor contributor : entityDescriptor.getStateArrayContributors()) {
            int position = contributor.getStateArrayPosition();
            if (originalValues[position] == LazyPropertyInitializer.UNFETCHED_PROPERTY || originalValues[position] == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
                copied[position] = targetValues[position];
                continue;
            }
            if (targetValues[position] == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                if (contributor.getMutabilityPlan().isMutable()) {
                    copied[position] = contributor.getMutabilityPlan().deepCopy(originalValues[position]);
                    continue;
                }
                copied[position] = originalValues[position];
                continue;
            }
            copied[position] = contributor.replace(originalValues[position], targetValues[position], owner, copyCache, session);
        }
        return copied;
    }

    public static Object[] replaceAssociations(ManagedTypeDescriptor<?> managedTypeDescriptor, Object original, Object target, Map copyCache, Object owner, ForeignKeyDirection foreignKeyDirection, SessionImplementor session) {
        List contributors = managedTypeDescriptor.getStateArrayContributors();
        Object[] originalValues = original == null ? new Object[contributors.size()] : managedTypeDescriptor.getPropertyValues(original);
        Object[] targetValues = target == null ? new Object[contributors.size()] : managedTypeDescriptor.getPropertyValues(target);
        Object[] copied = new Object[originalValues.length];
        for (StateArrayContributor contributor : contributors) {
            int position = contributor.getStateArrayPosition();
            if (originalValues[position] == LazyPropertyInitializer.UNFETCHED_PROPERTY || originalValues[position] == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
                copied[position] = targetValues[position];
                continue;
            }
            if (contributor instanceof EmbeddedValuedNavigable) {
                TypeHelper.replaceAssociations(((EmbeddedValuedNavigable)((Object)contributor)).getEmbeddedDescriptor(), originalValues[position], targetValues[position], copyCache, owner, foreignKeyDirection, session);
                copied[position] = targetValues[position];
                continue;
            }
            if (contributor instanceof EntityValuedNavigable || contributor instanceof PluralPersistentAttribute) {
                copied[position] = contributor.replace(originalValues[position], targetValues[position], owner, copyCache, foreignKeyDirection, session);
                continue;
            }
            copied[position] = targetValues[position];
        }
        return copied;
    }
}

