/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import org.hibernate.boot.model.domain.ResolutionContext;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.internal.UserTypeSqlExpressableTypeAdapter;
import org.hibernate.type.spi.BasicType;
import org.hibernate.usertype.UserType;

public class UserTypeAdapter<J>
implements BasicType<J> {
    private final UserType userType;
    private final String name;
    private final BasicJavaDescriptor<J> jtd;
    private final SqlExpressableType sqlExpressableType;

    private UserTypeAdapter(UserType userType, String name, BasicJavaDescriptor<J> jtd, SqlTypeDescriptor std) {
        this.userType = userType;
        this.name = name;
        this.jtd = jtd;
        this.sqlExpressableType = new UserTypeSqlExpressableTypeAdapter(jtd, std, userType);
    }

    public UserTypeAdapter(UserType userType, String name, ResolutionContext resolutionContext) {
        this(userType, name, (BasicJavaDescriptor)resolutionContext.getBootstrapContext().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(userType.returnedClass()), resolutionContext.getBootstrapContext().getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(userType.sqlTypeCode()));
    }

    public UserTypeAdapter(UserType userType, String name, BasicJavaDescriptor explicitJtd, SqlTypeDescriptor explicitStd, ResolutionContext resolutionContext) {
        this(userType, name, UserTypeAdapter.determineJavaTypeDescriptor(userType, explicitJtd, resolutionContext), explicitStd != null ? explicitStd : resolutionContext.getBootstrapContext().getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(userType.sqlTypeCode()));
    }

    private static <J> BasicJavaDescriptor<J> determineJavaTypeDescriptor(UserType userType, BasicJavaDescriptor explicitJtd, ResolutionContext resolutionContext) {
        if (explicitJtd != null) {
            return explicitJtd;
        }
        return UserTypeAdapter.determineJavaTypeDescriptor(userType, resolutionContext);
    }

    private static <J> BasicJavaDescriptor<J> determineJavaTypeDescriptor(UserType userType, ResolutionContext resolutionContext) {
        Class domainJavaType = userType.returnedClass();
        return (BasicJavaDescriptor)resolutionContext.getBootstrapContext().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(domainJavaType);
    }

    @Override
    public BasicJavaDescriptor<J> getJavaTypeDescriptor() {
        return this.jtd;
    }

    @Override
    public SqlTypeDescriptor getSqlTypeDescriptor() {
        return this.getSqlExpressableType().getSqlTypeDescriptor();
    }

    @Override
    public SqlExpressableType getSqlExpressableType() {
        return this.sqlExpressableType;
    }

    public String toString() {
        return "UserTypeAdapter(" + this.userType + " : " + this.name + ")";
    }
}

