/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.sql.JdbcValueBinder;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.ProcedureParameterNamedBinder;
import org.hibernate.usertype.UserType;

public class UserTypeBinderAdapter<T>
implements JdbcValueBinder<T> {
    private final UserType userType;
    private final boolean canBindToCallable;

    public UserTypeBinderAdapter(UserType userType) {
        this.userType = userType;
        this.canBindToCallable = userType instanceof ProcedureParameterNamedBinder;
    }

    @Override
    public void bind(PreparedStatement statement, int parameterPosition, T value, ExecutionContext executionContext) throws SQLException {
        this.userType.nullSafeSet(statement, value, parameterPosition, executionContext.getSession());
    }

    @Override
    public void bind(CallableStatement statement, String parameterName, T value, ExecutionContext executionContext) throws SQLException {
        if (!this.canBindToCallable) {
            throw new UnsupportedOperationException("UserType [" + this.userType.getClass().getName() + "] does not implement " + ProcedureParameterNamedBinder.class.getName() + ", cannot bind to JDBC CallableStatement");
        }
        ((ProcedureParameterNamedBinder)((Object)this.userType)).nullSafeSet(statement, value, parameterName, executionContext.getSession());
    }
}

