/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.ProcedureParameterExtractionAware;
import org.hibernate.usertype.UserType;

public class UserTypeExtractorAdaptor<T>
implements JdbcValueExtractor<T> {
    private final UserType userType;
    private final boolean canExtractFromCallable;

    public UserTypeExtractorAdaptor(UserType userType) {
        this.userType = userType;
        this.canExtractFromCallable = userType instanceof ProcedureParameterExtractionAware;
    }

    @Override
    public T extract(ResultSet resultSet, int jdbcParameterPosition, ExecutionContext executionContext) throws SQLException {
        return (T)this.userType.nullSafeGet(resultSet, jdbcParameterPosition, executionContext.getSession());
    }

    @Override
    public T extract(CallableStatement statement, int jdbcParameterPosition, ExecutionContext executionContext) throws SQLException {
        if (this.canExtractFromCallable) {
            return ((ProcedureParameterExtractionAware)((Object)this.userType)).extract(statement, jdbcParameterPosition, executionContext.getSession());
        }
        throw new UnsupportedOperationException("UserType [" + this.userType.getClass().getName() + "] does not implement " + ProcedureParameterExtractionAware.class.getName() + ", cannot extract values from CallableStatement");
    }

    @Override
    public T extract(CallableStatement statement, String jdbcParameterName, ExecutionContext executionContext) throws SQLException {
        if (this.canExtractFromCallable) {
            return ((ProcedureParameterExtractionAware)((Object)this.userType)).extract(statement, jdbcParameterName, executionContext.getSession());
        }
        throw new UnsupportedOperationException("UserType [" + this.userType.getClass().getName() + "] does not implement " + ProcedureParameterExtractionAware.class.getName() + ", cannot extract values from CallableStatement");
    }
}

