/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.spi;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.metamodel.model.domain.spi.BasicValueMapper;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.spi.BasicType;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

@Incubating
public class BasicTypeRegistry {
    private static final Logger log = Logger.getLogger(BasicTypeRegistry.class);
    private final TypeConfiguration typeConfiguration;
    private final Map<SqlTypeDescriptor, Map<BasicJavaDescriptor, BasicType>> registryValues = new ConcurrentHashMap<SqlTypeDescriptor, Map<BasicJavaDescriptor, BasicType>>();
    private final Map<String, BasicType> typesByName = new ConcurrentHashMap<String, BasicType>();
    private final Map<String, BasicValueMapper> mapperMap = new ConcurrentHashMap<String, BasicValueMapper>();

    public BasicTypeRegistry(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public BasicType<?> resolve(BasicJavaDescriptor<?> jtdToUse, SqlTypeDescriptor stdToUse) {
        Map mappingsForStdToUse = this.registryValues.computeIfAbsent(stdToUse, sqlTypeDescriptor -> new ConcurrentHashMap());
        return mappingsForStdToUse.computeIfAbsent(jtdToUse, javaDescriptor -> new BasicTypeImpl((BasicJavaDescriptor)javaDescriptor, stdToUse, stdToUse.getSqlExpressableType(jtdToUse, this.typeConfiguration)));
    }

    public BasicType getBasicTypeByName(String key) {
        return this.typesByName.get(key);
    }

    public <T> BasicType<T> getBasicType(Class<T> javaType) {
        JavaTypeDescriptor<T> jtd = this.typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(javaType);
        if (!BasicJavaDescriptor.class.isInstance(jtd)) {
            throw new HibernateException(String.format(Locale.ROOT, "Previously registered non-basic JavaTypeDescriptor [%s] found for Class [%s]; cannot create BasicType", jtd, javaType.getName()));
        }
        SqlTypeDescriptor recommendedStd = jtd.getJdbcRecommendedSqlType(this.typeConfiguration.getCurrentBaseSqlTypeIndicators());
        return this.resolve((BasicJavaDescriptor)jtd, recommendedStd);
    }

    public void register(BasicType type) {
        this.typesByName.put(type.getJavaTypeDescriptor().getJavaType().getName(), type);
    }

    public void register(BasicType type, String key) {
        this.typesByName.put(key, type);
    }

    public void register(BasicType type, String ... keys) {
        for (String key : keys) {
            this.typesByName.put(key, type);
        }
    }

    public void register(BasicValueMapper valueMapper, String ... keys) {
        for (String key : keys) {
            BasicValueMapper old = this.mapperMap.put(key, valueMapper);
            if (old == null || old == valueMapper) continue;
            log.debugf("BasicValueMapper registration [%s] overrode previous : %s -> %s", (Object)key, (Object)old, (Object)valueMapper);
        }
    }
}

