/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.spi;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.convert.spi.SimpleBasicValueConverter;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.internal.BigDecimalJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.BigIntegerJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.BlobJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.BooleanJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.ByteArrayJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.ByteJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.CalendarDateJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.CalendarJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.CalendarTimeJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.CharacterArrayJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.CharacterJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.ClassJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.ClobJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.CurrencyJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.DoubleJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.DurationJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.FloatJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.InstantJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.IntegerJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.JdbcDateJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.JdbcTimeJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.JdbcTimestampJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.LocalDateJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.LocalDateTimeJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.LocalTimeJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.LocaleJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.LongJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.NClobJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.OffsetDateTimeJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.OffsetTimeJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.PrimitiveByteArrayJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.PrimitiveCharacterArrayJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.SerializableJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.ShortJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.StringJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.TimeZoneJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.UUIDJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.UrlJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.ZonedDateTimeJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.BigIntSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.BinarySqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.BitSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.BlobSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.CharSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.ClobSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.DateSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.DoubleSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.FloatSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.IntegerSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.LongNVarcharSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.LongVarbinarySqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.LongVarcharSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.NCharSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.NClobSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.NVarcharSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.NumericSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.SmallIntSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.TimeSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.TimestampSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.TinyIntSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.VarbinarySqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.VarcharSqlDescriptor;
import org.hibernate.type.internal.StandardBasicTypeImpl;
import org.hibernate.type.spi.BasicType;
import org.hibernate.type.spi.BasicTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public final class StandardSpiBasicTypes {
    public static final StandardBasicType<Boolean> BOOLEAN = new StandardBasicTypeImpl<Boolean>(BooleanJavaDescriptor.INSTANCE, BitSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Boolean> NUMERIC_BOOLEAN = new StandardBasicTypeImpl<Boolean>(BooleanJavaDescriptor.INSTANCE, IntegerJavaDescriptor.INSTANCE, NumericSqlDescriptor.INSTANCE, new SimpleBasicValueConverter<Boolean, Integer>(BooleanJavaDescriptor.INSTANCE, IntegerJavaDescriptor.INSTANCE, (r, sessionContractImplementor) -> r != null && r == 1, (d, sessionContractImplementor) -> d != null && d != false ? 1 : 0));
    public static final StandardBasicType<Boolean> TRUE_FALSE = new StandardBasicTypeImpl<Boolean>(BooleanJavaDescriptor.INSTANCE, CharacterJavaDescriptor.INSTANCE, CharSqlDescriptor.INSTANCE, new SimpleBasicValueConverter<Boolean, Character>(BooleanJavaDescriptor.INSTANCE, CharacterJavaDescriptor.INSTANCE, (r, sessionContractImplementor) -> r != null && r.charValue() == 'T', (d, sessionContractImplementor) -> Character.valueOf((char)(d != null && d != false ? 84 : 70))));
    public static final StandardBasicType<Boolean> YES_NO = new StandardBasicTypeImpl<Boolean>(BooleanJavaDescriptor.INSTANCE, CharacterJavaDescriptor.INSTANCE, CharSqlDescriptor.INSTANCE, new SimpleBasicValueConverter<Boolean, Character>(BooleanJavaDescriptor.INSTANCE, CharacterJavaDescriptor.INSTANCE, (r, sessionContractImplementor) -> r != null && r.charValue() == 'Y', (d, sessionContractImplementor) -> Character.valueOf((char)(d != null && d != false ? 89 : 78))));
    public static final StandardBasicType<Byte> BYTE = new StandardBasicTypeImpl<Byte>(ByteJavaDescriptor.INSTANCE, TinyIntSqlDescriptor.INSTANCE);
    public static final StandardBasicType<byte[]> BINARY = new StandardBasicTypeImpl<byte[]>(PrimitiveByteArrayJavaDescriptor.INSTANCE, VarbinarySqlDescriptor.INSTANCE);
    public static final StandardBasicType<Byte[]> WRAPPER_BINARY = new StandardBasicTypeImpl<Byte[]>(ByteArrayJavaDescriptor.INSTANCE, VarbinarySqlDescriptor.INSTANCE);
    public static final StandardBasicType<byte[]> IMAGE = new StandardBasicTypeImpl<byte[]>(PrimitiveByteArrayJavaDescriptor.INSTANCE, LongVarbinarySqlDescriptor.INSTANCE);
    public static final StandardBasicType<Blob> BLOB = new StandardBasicTypeImpl<Blob>(BlobJavaDescriptor.INSTANCE, BlobSqlDescriptor.BLOB_BINDING);
    public static final StandardBasicType<byte[]> MATERIALIZED_BLOB = new StandardBasicTypeImpl<byte[]>(PrimitiveByteArrayJavaDescriptor.INSTANCE, BlobSqlDescriptor.BLOB_BINDING);
    public static final StandardBasicType<Short> SHORT = new StandardBasicTypeImpl<Short>(ShortJavaDescriptor.INSTANCE, SmallIntSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Integer> INTEGER = new StandardBasicTypeImpl<Integer>(IntegerJavaDescriptor.INSTANCE, IntegerSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Long> LONG = new StandardBasicTypeImpl<Long>(LongJavaDescriptor.INSTANCE, BigIntSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Float> FLOAT = new StandardBasicTypeImpl<Float>(FloatJavaDescriptor.INSTANCE, FloatSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Double> DOUBLE = new StandardBasicTypeImpl<Double>(DoubleJavaDescriptor.INSTANCE, DoubleSqlDescriptor.INSTANCE);
    public static final StandardBasicType<BigInteger> BIG_INTEGER = new StandardBasicTypeImpl<BigInteger>(BigIntegerJavaDescriptor.INSTANCE, NumericSqlDescriptor.INSTANCE);
    public static final StandardBasicType<BigDecimal> BIG_DECIMAL = new StandardBasicTypeImpl<BigDecimal>(BigDecimalJavaDescriptor.INSTANCE, NumericSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Character> CHARACTER = new StandardBasicTypeImpl<Character>(CharacterJavaDescriptor.INSTANCE, CharSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Character> CHARACTER_NCHAR = new StandardBasicTypeImpl<Character>(CharacterJavaDescriptor.INSTANCE, NCharSqlDescriptor.INSTANCE);
    public static final StandardBasicType<String> STRING = new StandardBasicTypeImpl<String>(StringJavaDescriptor.INSTANCE, VarcharSqlDescriptor.INSTANCE);
    public static final StandardBasicType<String> NSTRING = new StandardBasicTypeImpl<String>(StringJavaDescriptor.INSTANCE, NVarcharSqlDescriptor.INSTANCE);
    public static final StandardBasicType<char[]> CHAR_ARRAY = new StandardBasicTypeImpl<char[]>(PrimitiveCharacterArrayJavaDescriptor.INSTANCE, VarcharSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Character[]> CHARACTER_ARRAY = new StandardBasicTypeImpl<Character[]>(CharacterArrayJavaDescriptor.INSTANCE, VarcharSqlDescriptor.INSTANCE);
    public static final StandardBasicType<String> TEXT = new StandardBasicTypeImpl<String>(StringJavaDescriptor.INSTANCE, LongVarcharSqlDescriptor.INSTANCE);
    public static final StandardBasicType<String> NTEXT = new StandardBasicTypeImpl<String>(StringJavaDescriptor.INSTANCE, LongNVarcharSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Clob> CLOB = new StandardBasicTypeImpl<Clob>(ClobJavaDescriptor.INSTANCE, ClobSqlDescriptor.CLOB_BINDING);
    public static final StandardBasicType<NClob> NCLOB = new StandardBasicTypeImpl<NClob>(NClobJavaDescriptor.INSTANCE, NClobSqlDescriptor.NCLOB_BINDING);
    public static final StandardBasicType<String> MATERIALIZED_CLOB = new StandardBasicTypeImpl<String>(StringJavaDescriptor.INSTANCE, ClobSqlDescriptor.CLOB_BINDING);
    public static final StandardBasicType<byte[]> WRAPPED_MATERIALIZED_BLOB = new StandardBasicTypeImpl<Byte[]>(ByteArrayJavaDescriptor.INSTANCE, BlobSqlDescriptor.BLOB_BINDING);
    public static final StandardBasicType<Character[]> MATERIALIZED_NCLOB_CHARACTER_ARRAY = new StandardBasicTypeImpl<Character[]>(CharacterArrayJavaDescriptor.INSTANCE, NClobSqlDescriptor.NCLOB_BINDING);
    public static final StandardBasicType<String> MATERIALIZED_CLOB_CHAR_ARRAY = new StandardBasicTypeImpl<char[]>(PrimitiveCharacterArrayJavaDescriptor.INSTANCE, ClobSqlDescriptor.CLOB_BINDING);
    public static final StandardBasicType<String> MATERIALIZED_CLOB_CHARACTER_ARRAY = new StandardBasicTypeImpl<Character[]>(CharacterArrayJavaDescriptor.INSTANCE, ClobSqlDescriptor.CLOB_BINDING);
    public static final StandardBasicType<String> MATERIALIZED_NCLOB_CHAR_ARRAY = new StandardBasicTypeImpl<char[]>(PrimitiveCharacterArrayJavaDescriptor.INSTANCE, NClobSqlDescriptor.NCLOB_BINDING);
    public static final StandardBasicType<String> MATERIALIZED_NCLOB = new StandardBasicTypeImpl<String>(StringJavaDescriptor.INSTANCE, NClobSqlDescriptor.NCLOB_BINDING);
    public static final StandardBasicType<Duration> DURATION = new StandardBasicTypeImpl<Duration>(DurationJavaDescriptor.INSTANCE, BigIntSqlDescriptor.INSTANCE);
    public static final StandardBasicType<LocalDateTime> LOCAL_DATE_TIME = new StandardBasicTypeImpl<LocalDateTime>(LocalDateTimeJavaDescriptor.INSTANCE, TimestampSqlDescriptor.INSTANCE);
    public static final StandardBasicType<LocalDate> LOCAL_DATE = new StandardBasicTypeImpl<LocalDate>(LocalDateJavaDescriptor.INSTANCE, DateSqlDescriptor.INSTANCE);
    public static final StandardBasicType<LocalTime> LOCAL_TIME = new StandardBasicTypeImpl<LocalTime>(LocalTimeJavaDescriptor.INSTANCE, TimeSqlDescriptor.INSTANCE);
    public static final StandardBasicType<OffsetDateTime> OFFSET_DATE_TIME = new StandardBasicTypeImpl<OffsetDateTime>(OffsetDateTimeJavaDescriptor.INSTANCE, TimestampSqlDescriptor.INSTANCE);
    public static final StandardBasicType<OffsetTime> OFFSET_TIME = new StandardBasicTypeImpl<OffsetTime>(OffsetTimeJavaDescriptor.INSTANCE, TimeSqlDescriptor.INSTANCE);
    public static final StandardBasicType<ZonedDateTime> ZONED_DATE_TIME = new StandardBasicTypeImpl<ZonedDateTime>(ZonedDateTimeJavaDescriptor.INSTANCE, TimestampSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Date> TIME = new StandardBasicTypeImpl<Date>(JdbcTimeJavaDescriptor.INSTANCE, TimeSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Date> DATE = new StandardBasicTypeImpl<Date>(JdbcDateJavaDescriptor.INSTANCE, DateSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Date> TIMESTAMP = new StandardBasicTypeImpl<Date>(JdbcTimestampJavaDescriptor.INSTANCE, TimestampSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Calendar> CALENDAR = new StandardBasicTypeImpl<Calendar>(CalendarJavaDescriptor.INSTANCE, TimestampSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Calendar> CALENDAR_DATE = new StandardBasicTypeImpl<Calendar>(CalendarDateJavaDescriptor.INSTANCE, DateSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Calendar> CALENDAR_TIME = new StandardBasicTypeImpl<Calendar>(CalendarTimeJavaDescriptor.INSTANCE, TimeSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Instant> INSTANT = new StandardBasicTypeImpl<Instant>(InstantJavaDescriptor.INSTANCE, TimestampSqlDescriptor.INSTANCE);
    public static final StandardBasicType<UUID> UUID_BINARY = new StandardBasicTypeImpl<UUID>(UUIDJavaDescriptor.INSTANCE, BinarySqlDescriptor.INSTANCE);
    public static final StandardBasicType<UUID> UUID_CHAR = new StandardBasicTypeImpl<UUID>(UUIDJavaDescriptor.INSTANCE, CharSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Class> CLASS = new StandardBasicTypeImpl<Class>(ClassJavaDescriptor.INSTANCE, VarcharSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Currency> CURRENCY = new StandardBasicTypeImpl<Currency>(CurrencyJavaDescriptor.INSTANCE, VarcharSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Locale> LOCALE = new StandardBasicTypeImpl<Locale>(LocaleJavaDescriptor.INSTANCE, VarcharSqlDescriptor.INSTANCE);
    public static final StandardBasicType<Serializable> SERIALIZABLE = new StandardBasicTypeImpl<Serializable>(SerializableJavaDescriptor.INSTANCE, VarbinarySqlDescriptor.INSTANCE);
    public static final StandardBasicType<TimeZone> TIMEZONE = new StandardBasicTypeImpl<TimeZone>(TimeZoneJavaDescriptor.INSTANCE, VarcharSqlDescriptor.INSTANCE);
    public static final StandardBasicType<URL> URL = new StandardBasicTypeImpl<URL>(UrlJavaDescriptor.INSTANCE, VarcharSqlDescriptor.INSTANCE);

    private StandardSpiBasicTypes() {
    }

    public static void prime(TypeConfiguration typeConfiguration) {
        StandardSpiBasicTypes.handle(BOOLEAN, "org.hibernate.type.BooleanType", typeConfiguration, "boolean", Boolean.TYPE.getName(), Boolean.class.getName());
        StandardSpiBasicTypes.handle(NUMERIC_BOOLEAN, "org.hibernate.type.NumericBooleanType", typeConfiguration, "numeric_boolean");
        StandardSpiBasicTypes.handle(TRUE_FALSE, "org.hibernate.type.TrueFalseType", typeConfiguration, "true_false");
        StandardSpiBasicTypes.handle(YES_NO, "org.hibernate.type.YesNoType", typeConfiguration, "yes_no");
        StandardSpiBasicTypes.handle(BYTE, "org.hibernate.type.ByteType", typeConfiguration, "byte", Byte.TYPE.getName(), Byte.class.getName());
        StandardSpiBasicTypes.handle(BINARY, "org.hibernate.type.BinaryType", typeConfiguration, "binary", "byte[]", byte[].class.getName());
        StandardSpiBasicTypes.handle(WRAPPER_BINARY, "org.hibernate.type.WrapperBinaryType", typeConfiguration, "wrapper-binary", "Byte[]", Byte[].class.getName());
        StandardSpiBasicTypes.handle(IMAGE, "org.hibernate.type.ImageType", typeConfiguration, "image");
        StandardSpiBasicTypes.handle(BLOB, "org.hibernate.type.BlobType", typeConfiguration, "blob", Blob.class.getName());
        StandardSpiBasicTypes.handle(MATERIALIZED_BLOB, "org.hibernate.type.MaterializedBlobType", typeConfiguration, "materialized_blob");
        StandardSpiBasicTypes.handle(WRAPPED_MATERIALIZED_BLOB, "org.hibernate.type.MaterializedBlobType", typeConfiguration, "wrapped_materialized_blob");
        StandardSpiBasicTypes.handle(SHORT, "org.hibernate.type.ShortType", typeConfiguration, "short", Short.TYPE.getName(), Short.class.getName());
        StandardSpiBasicTypes.handle(INTEGER, "org.hibernate.type.IntegerType", typeConfiguration, "integer", Integer.TYPE.getName(), Integer.class.getName());
        StandardSpiBasicTypes.handle(LONG, "org.hibernate.type.LongType", typeConfiguration, "long", Long.TYPE.getName(), Long.class.getName());
        StandardSpiBasicTypes.handle(FLOAT, "org.hibernate.type.FloatType", typeConfiguration, "float", Float.TYPE.getName(), Float.class.getName());
        StandardSpiBasicTypes.handle(DOUBLE, "org.hibernate.type.DoubleType", typeConfiguration, "double", Double.TYPE.getName(), Double.class.getName());
        StandardSpiBasicTypes.handle(BIG_INTEGER, "org.hibernate.type.BigIntegerType", typeConfiguration, "big_integer", BigInteger.class.getName());
        StandardSpiBasicTypes.handle(BIG_DECIMAL, "org.hibernate.type.BigDecimalType", typeConfiguration, "big_decimal", BigDecimal.class.getName());
        StandardSpiBasicTypes.handle(CHARACTER, "org.hibernate.type.CharacterType", typeConfiguration, "character", Character.TYPE.getName(), Character.class.getName());
        StandardSpiBasicTypes.handle(CHARACTER_NCHAR, null, typeConfiguration, "character_nchar");
        StandardSpiBasicTypes.handle(STRING, "org.hibernate.type.StringType", typeConfiguration, "string", String.class.getName());
        StandardSpiBasicTypes.handle(NSTRING, "org.hibernate.type.StringNVarcharType", typeConfiguration, "nstring");
        StandardSpiBasicTypes.handle(CHAR_ARRAY, "org.hibernate.type.CharArrayType", typeConfiguration, "characters", "char[]", char[].class.getName());
        StandardSpiBasicTypes.handle(CHARACTER_ARRAY, "org.hibernate.type.CharacterArrayType", typeConfiguration, "wrapper-characters", Character[].class.getName(), "Character[]");
        StandardSpiBasicTypes.handle(TEXT, "org.hibernate.type.TextType", typeConfiguration, "text");
        StandardSpiBasicTypes.handle(NTEXT, "org.hibernate.type.NTextType", typeConfiguration, "ntext");
        StandardSpiBasicTypes.handle(CLOB, "org.hibernate.type.ClobType", typeConfiguration, "clob", Clob.class.getName());
        StandardSpiBasicTypes.handle(NCLOB, "org.hibernate.type.NClobType", typeConfiguration, "nclob", NClob.class.getName());
        StandardSpiBasicTypes.handle(MATERIALIZED_CLOB, "org.hibernate.type.MaterializedClobType", typeConfiguration, "materialized_clob");
        StandardSpiBasicTypes.handle(MATERIALIZED_CLOB_CHAR_ARRAY, "org.hibernate.type.PrimitiveCharacterArrayClobType", typeConfiguration, "materialized_clob_char_array");
        StandardSpiBasicTypes.handle(MATERIALIZED_CLOB_CHARACTER_ARRAY, "org.hibernate.type.CharacterArrayClobType", typeConfiguration, "materialized_clob_character_array");
        StandardSpiBasicTypes.handle(MATERIALIZED_NCLOB, "org.hibernate.type.MaterializedNClobType", typeConfiguration, "materialized_nclob");
        StandardSpiBasicTypes.handle(MATERIALIZED_NCLOB_CHARACTER_ARRAY, "org.hibernate.type.CharacterArrayNClobType", typeConfiguration, "materialized_nclob_character_array");
        StandardSpiBasicTypes.handle(MATERIALIZED_NCLOB_CHAR_ARRAY, "org.hibernate.type.PrimitiveCharacterArrayNClobType", typeConfiguration, "materialized_nclob_char_array");
        StandardSpiBasicTypes.handle(DURATION, "org.hibernate.type.DurationType", typeConfiguration, Duration.class.getSimpleName(), Duration.class.getName());
        StandardSpiBasicTypes.handle(LOCAL_DATE_TIME, "org.hibernate.type.LocalDateTimeType", typeConfiguration, LocalDateTime.class.getSimpleName(), LocalDateTime.class.getName());
        StandardSpiBasicTypes.handle(LOCAL_DATE, "org.hibernate.type.LocalDateType", typeConfiguration, LocalDate.class.getSimpleName(), LocalDate.class.getName());
        StandardSpiBasicTypes.handle(LOCAL_TIME, "org.hibernate.type.LocalTimeType", typeConfiguration, LocalTime.class.getSimpleName(), LocalTime.class.getName());
        StandardSpiBasicTypes.handle(OFFSET_DATE_TIME, "org.hibernate.type.OffsetDateTimeType", typeConfiguration, OffsetDateTime.class.getSimpleName(), OffsetDateTime.class.getName());
        StandardSpiBasicTypes.handle(OFFSET_TIME, "org.hibernate.type.OffsetTimeType", typeConfiguration, OffsetTime.class.getSimpleName(), OffsetTime.class.getName());
        StandardSpiBasicTypes.handle(ZONED_DATE_TIME, "org.hibernate.type.ZonedDateTimeType", typeConfiguration, ZonedDateTime.class.getSimpleName(), ZonedDateTime.class.getName());
        StandardSpiBasicTypes.handle(DATE, "org.hibernate.type.DateType", typeConfiguration, "date", java.sql.Date.class.getName());
        StandardSpiBasicTypes.handle(TIME, "org.hibernate.type.TimeType", typeConfiguration, "time", Time.class.getName());
        StandardSpiBasicTypes.handle(TIMESTAMP, "org.hibernate.type.TimestampType", typeConfiguration, "timestamp", Timestamp.class.getName(), Date.class.getName());
        StandardSpiBasicTypes.handle(CALENDAR, "org.hibernate.type.CalendarType", typeConfiguration, "calendar", Calendar.class.getName(), GregorianCalendar.class.getName());
        StandardSpiBasicTypes.handle(CALENDAR_DATE, "org.hibernate.type.CalendarDateType", typeConfiguration, "calendar_date");
        StandardSpiBasicTypes.handle(CALENDAR_TIME, "org.hibernate.type.CalendarTimeType", typeConfiguration, "calendar_date");
        StandardSpiBasicTypes.handle(INSTANT, "org.hibernate.type.InstantType", typeConfiguration, "instant", Instant.class.getName());
        StandardSpiBasicTypes.handle(UUID_BINARY, "org.hibernate.type.UUIDBinaryType", typeConfiguration, "uuid-binary", UUID.class.getName());
        StandardSpiBasicTypes.handle(UUID_CHAR, "org.hibernate.type.UUIDCharType", typeConfiguration, "uuid-char");
        StandardSpiBasicTypes.handle(CLASS, "org.hibernate.type.ClassType", typeConfiguration, "class", Class.class.getName());
        StandardSpiBasicTypes.handle(CURRENCY, "org.hibernate.type.CurrencyType", typeConfiguration, "currency", Currency.class.getSimpleName(), Currency.class.getName());
        StandardSpiBasicTypes.handle(LOCALE, "org.hibernate.type.LocaleType", typeConfiguration, "locale", Locale.class.getName());
        StandardSpiBasicTypes.handle(SERIALIZABLE, "org.hibernate.type.SerializableType", typeConfiguration, "serializable", Serializable.class.getName());
        StandardSpiBasicTypes.handle(TIMEZONE, "org.hibernate.type.TimeZoneType", typeConfiguration, "timezone", TimeZone.class.getName());
        StandardSpiBasicTypes.handle(URL, "org.hibernate.type.UrlType", typeConfiguration, "url", URL.class.getName());
    }

    private static void handle(StandardBasicType type, String legacyTypeClassName, TypeConfiguration typeConfiguration, String ... registrationKeys) {
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        if (StringHelper.isNotEmpty(legacyTypeClassName)) {
            basicTypeRegistry.register((BasicType)type, legacyTypeClassName);
        }
        basicTypeRegistry.register((BasicType)type, registrationKeys);
    }

    public static interface StandardBasicType<J>
    extends StandardBasicTypes.StandardBasicType<J>,
    BasicType<J> {
    }
}

