/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.spi;

import java.io.InvalidObjectException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.persistence.EnumType;
import javax.persistence.metamodel.Type;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.cfgxml.spi.CfgXmlAccessService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.uuid.LocalObjectUuidHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationProcess;
import org.hibernate.metamodel.model.domain.spi.BasicTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.BasicValueMapper;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptorRegistry;
import org.hibernate.type.internal.TypeConfigurationRegistry;
import org.hibernate.type.spi.BasicType;
import org.hibernate.type.spi.BasicTypeRegistry;
import org.hibernate.type.spi.StandardSpiBasicTypes;

@Incubating
public class TypeConfiguration
implements SessionFactoryObserver,
Serializable {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Scope.class);
    private final String uuid = LocalObjectUuidHelper.generateLocalObjectUuid();
    private final Scope scope;
    private boolean initialized;
    private final transient JavaTypeDescriptorRegistry javaTypeDescriptorRegistry;
    private final transient SqlTypeDescriptorRegistry sqlTypeDescriptorRegistry;
    private final transient BasicTypeRegistry basicTypeRegistry;
    private final transient Map<SqlTypeDescriptor, Map<BasicJavaDescriptor, SqlExpressableType>> jdbcValueMapperCache = new ConcurrentHashMap<SqlTypeDescriptor, Map<BasicJavaDescriptor, SqlExpressableType>>();
    private final Map<String, BasicValueMapper> namedMappers = new ConcurrentHashMap<String, BasicValueMapper>();
    private final ConcurrentHashMap<StandardBasicTypes.StandardBasicType<?>, BasicValueMapper<?>> standardBasicTypeResolutionCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<BasicJavaDescriptor<?>, BasicTypeResolution> basicTypeResolutionsByJavaType = new ConcurrentHashMap();

    public TypeConfiguration() {
        log.debugf("Instantiating TypeConfiguration : %s", this.uuid);
        this.scope = new Scope(this);
        this.javaTypeDescriptorRegistry = new JavaTypeDescriptorRegistry(this);
        this.sqlTypeDescriptorRegistry = new SqlTypeDescriptorRegistry(this);
        this.basicTypeRegistry = new BasicTypeRegistry(this);
        StandardSpiBasicTypes.prime(this);
        this.initialized = true;
        TypeConfigurationRegistry.INSTANCE.registerTypeConfiguration(this);
    }

    public String getUuid() {
        return this.uuid;
    }

    public JavaTypeDescriptorRegistry getJavaTypeDescriptorRegistry() {
        if (!this.initialized) {
            throw new IllegalStateException("TypeConfiguration initialization incomplete; not yet ready for access");
        }
        return this.javaTypeDescriptorRegistry;
    }

    public SqlTypeDescriptorRegistry getSqlTypeDescriptorRegistry() {
        if (!this.initialized) {
            throw new IllegalStateException("TypeConfiguration initialization incomplete; not yet ready for access");
        }
        return this.sqlTypeDescriptorRegistry;
    }

    public SqlTypeDescriptorIndicators getCurrentBaseSqlTypeIndicators() {
        return this.scope.getCurrentBaseSqlTypeIndicators();
    }

    public <J> BasicTypeResolution<J> resolveStandardBasicType(StandardBasicTypes.StandardBasicType<J> standardBasicType) {
        return (BasicTypeResolution)this.standardBasicTypeResolutionCache.computeIfAbsent(standardBasicType, key -> new StandardBasicTypeResolutionImpl(standardBasicType));
    }

    public <J> BasicValuedExpressableType<J> standardExpressableTypeForJavaType(Class<J> javaType) {
        return this.standardExpressableTypeForJavaType((BasicJavaDescriptor)this.getJavaTypeDescriptorRegistry().getDescriptor(javaType));
    }

    public <J> BasicTypeResolution<J> standardExpressableTypeForJavaType(BasicJavaDescriptor<J> javaTypeDescriptor) {
        return this.basicTypeResolutionsByJavaType.computeIfAbsent(javaTypeDescriptor, x$0 -> new StandardJavaTypeResolutionImpl(x$0));
    }

    public BasicTypeRegistry getBasicTypeRegistry() {
        return this.basicTypeRegistry;
    }

    public SqlExpressableType resolveSqlExpressableType(SqlTypeDescriptor sqlTypeDescriptor, BasicJavaDescriptor javaDescriptor, Function<BasicJavaDescriptor, SqlExpressableType> creator) {
        Map cacheForSqlType = this.jdbcValueMapperCache.computeIfAbsent(sqlTypeDescriptor, x -> new ConcurrentHashMap());
        return cacheForSqlType.computeIfAbsent(javaDescriptor, x -> (SqlExpressableType)creator.apply(javaDescriptor));
    }

    public SqlExpressableType resolveSqlExpressableType(SqlTypeDescriptor sqlTypeDescriptor, BasicJavaDescriptor javaDescriptor) {
        Map cacheForSqlType = this.jdbcValueMapperCache.computeIfAbsent(sqlTypeDescriptor, x -> new ConcurrentHashMap());
        SqlExpressableType sqlExpressableType = (SqlExpressableType)cacheForSqlType.get(javaDescriptor);
        if (sqlExpressableType == null) {
            throw new IllegalArgumentException("No SqlExpressableType cached for [" + sqlTypeDescriptor + "] and [" + javaDescriptor + "] combination");
        }
        return sqlExpressableType;
    }

    public MetadataBuildingContext getMetadataBuildingContext() {
        return this.scope.getMetadataBuildingContext();
    }

    public void scope(MetadataBuildingContext metadataBuildingContext) {
        log.debugf("Scoping TypeConfiguration [%s] to MetadataBuildingContext [%s]", this, metadataBuildingContext);
        this.scope.setMetadataBuildingContext(metadataBuildingContext);
    }

    public MetamodelImplementor scope(SessionFactoryImplementor sessionFactory, BootstrapContext bootstrapContext) {
        assert (this.scope.metadataBuildingContext != null);
        log.debugf("Scoping TypeConfiguration [%s] to SessionFactoryImpl [%s]", this, sessionFactory);
        this.scope.setSessionFactory(sessionFactory);
        sessionFactory.addObserver(this);
        log.debugf("Scoping TypeConfiguration [%s] to SessionFactory [%s]", this, sessionFactory);
        return RuntimeModelCreationProcess.execute(sessionFactory, bootstrapContext, this.scope.getMetadataBuildingContext());
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.scope.getSessionFactory();
    }

    public ServiceRegistry getServiceRegistry() {
        return this.scope.getServiceRegistry();
    }

    @Override
    public void sessionFactoryCreated(SessionFactory factory) {
        log.tracef("Handling #sessionFactoryCreated from [%s] for TypeConfiguration", factory);
        this.scope.unsetMetadataBuildingContext();
    }

    @Override
    public void sessionFactoryClosed(SessionFactory factory) {
        log.tracef("Handling #sessionFactoryClosed from [%s] for TypeConfiguration", factory);
        TypeConfigurationRegistry.INSTANCE.deregisterTypeConfiguration(this);
        this.scope.unsetSessionFactory(factory);
    }

    public void registerBasicValueMapper(BasicValueMapper valueMapper, String ... registrationKeys) {
        for (String registrationKey : registrationKeys) {
            this.namedMappers.put(registrationKey, valueMapper);
        }
    }

    public BasicValueMapper getNamedBasicValueMapper(String name) {
        return this.namedMappers.get(name);
    }

    public BasicValuedExpressableType resolveArithmeticType(BasicValuedExpressableType firstType, BasicValuedExpressableType secondType, BinaryArithmeticOperator operator) {
        return this.resolveArithmeticType(firstType, secondType, operator == BinaryArithmeticOperator.DIVIDE);
    }

    public BasicValuedExpressableType resolveArithmeticType(BasicValuedExpressableType firstType, BasicValuedExpressableType secondType, boolean isDivision) {
        if (isDivision) {
            return this.getBasicTypeRegistry().getBasicType(Number.class);
        }
        if (TypeConfiguration.matchesJavaType(firstType, Double.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, Double.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, Float.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, Float.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, BigDecimal.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, BigDecimal.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, BigInteger.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, BigInteger.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, Long.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, Long.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, Integer.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, Integer.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, Short.class)) {
            return this.getBasicTypeRegistry().getBasicType(Integer.class);
        }
        if (TypeConfiguration.matchesJavaType(secondType, Short.class)) {
            return this.getBasicTypeRegistry().getBasicType(Integer.class);
        }
        return this.getBasicTypeRegistry().getBasicType(Number.class);
    }

    private static boolean matchesJavaType(BasicValuedExpressableType type, Class javaType) {
        assert (javaType != null);
        return type != null && javaType.isAssignableFrom(type.getJavaType());
    }

    public BasicValuedExpressableType resolveSumFunctionType(BasicValuedExpressableType argumentType) {
        if (TypeConfiguration.matchesJavaType(argumentType, Double.class)) {
            return argumentType;
        }
        if (TypeConfiguration.matchesJavaType(argumentType, Float.class)) {
            return argumentType;
        }
        if (TypeConfiguration.matchesJavaType(argumentType, BigDecimal.class)) {
            return argumentType;
        }
        if (TypeConfiguration.matchesJavaType(argumentType, BigInteger.class)) {
            return argumentType;
        }
        if (TypeConfiguration.matchesJavaType(argumentType, Long.class)) {
            return argumentType;
        }
        if (TypeConfiguration.matchesJavaType(argumentType, Integer.class)) {
            return argumentType;
        }
        if (TypeConfiguration.matchesJavaType(argumentType, Short.class)) {
            return this.getBasicTypeRegistry().getBasicType(Integer.class);
        }
        return this.getBasicTypeRegistry().getBasicType(Number.class);
    }

    public BasicType resolveCastTargetType(String name) {
        throw new NotYetImplementedException();
    }

    private Object readResolve() throws InvalidObjectException {
        log.trace("Resolving serialized TypeConfiguration - readResolve");
        return TypeConfigurationRegistry.INSTANCE.findTypeConfiguration(this.getUuid());
    }

    private static class Scope
    implements Serializable {
        private final TypeConfiguration typeConfiguration;
        private transient MetadataBuildingContext metadataBuildingContext;
        private transient SessionFactoryImplementor sessionFactory;
        private transient SqlTypeDescriptorIndicators currentSqlTypeIndicators = new SqlTypeDescriptorIndicators(){

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }

            @Override
            public int getPreferredSqlTypeCodeForBoolean() {
                return 16;
            }
        };
        private String sessionFactoryName;
        private String sessionFactoryUuid;

        public Scope(TypeConfiguration typeConfiguration) {
            this.typeConfiguration = typeConfiguration;
        }

        public SqlTypeDescriptorIndicators getCurrentBaseSqlTypeIndicators() {
            return this.currentSqlTypeIndicators;
        }

        public MetadataBuildingContext getMetadataBuildingContext() {
            if (this.metadataBuildingContext == null) {
                throw new HibernateException("TypeConfiguration is not currently scoped to MetadataBuildingContext");
            }
            return this.metadataBuildingContext;
        }

        public ServiceRegistry getServiceRegistry() {
            if (this.metadataBuildingContext != null) {
                return this.metadataBuildingContext.getBootstrapContext().getServiceRegistry();
            }
            if (this.sessionFactory != null) {
                return this.sessionFactory.getServiceRegistry();
            }
            return null;
        }

        public void setMetadataBuildingContext(final MetadataBuildingContext metadataBuildingContext) {
            this.metadataBuildingContext = metadataBuildingContext;
            this.currentSqlTypeIndicators = new SqlTypeDescriptorIndicators(){
                private final boolean globalNationalization;
                private final int preferredBooleanSqlTypeCode;
                private final EnumType implicitEnumStorage;
                {
                    this.globalNationalization = metadataBuildingContext.getBuildingOptions().useNationalizedCharacterData();
                    this.preferredBooleanSqlTypeCode = metadataBuildingContext.getPreferredSqlTypeCodeForBoolean();
                    this.implicitEnumStorage = metadataBuildingContext.getBuildingOptions().getImplicitEnumType();
                }

                @Override
                public boolean isNationalized() {
                    return this.globalNationalization;
                }

                @Override
                public int getPreferredSqlTypeCodeForBoolean() {
                    return this.preferredBooleanSqlTypeCode;
                }

                @Override
                public EnumType getEnumeratedType() {
                    return this.implicitEnumStorage;
                }

                @Override
                public TypeConfiguration getTypeConfiguration() {
                    return typeConfiguration;
                }
            };
        }

        public void unsetMetadataBuildingContext() {
            this.metadataBuildingContext = null;
        }

        public SessionFactoryImplementor getSessionFactory() {
            if (this.sessionFactory == null) {
                if (this.sessionFactoryName == null && this.sessionFactoryUuid == null) {
                    throw new HibernateException("TypeConfiguration was not yet scoped to SessionFactory");
                }
                this.sessionFactory = (SessionFactoryImplementor)SessionFactoryRegistry.INSTANCE.findSessionFactory(this.sessionFactoryUuid, this.sessionFactoryName);
                if (this.sessionFactory == null) {
                    throw new HibernateException("Could not find a SessionFactory [uuid=" + this.sessionFactoryUuid + ",name=" + this.sessionFactoryName + "]");
                }
            }
            return this.sessionFactory;
        }

        void setSessionFactory(SessionFactoryImplementor factory) {
            if (this.sessionFactory != null) {
                log.scopingTypesToSessionFactoryAfterAlreadyScoped(this.sessionFactory, factory);
            } else {
                CfgXmlAccessService cfgXmlAccessService;
                this.sessionFactoryUuid = factory.getUuid();
                String sfName = factory.getSessionFactoryOptions().getSessionFactoryName();
                if (sfName == null && (cfgXmlAccessService = factory.getServiceRegistry().getService(CfgXmlAccessService.class)).getAggregatedConfig() != null) {
                    sfName = cfgXmlAccessService.getAggregatedConfig().getSessionFactoryName();
                }
                this.sessionFactoryName = sfName;
            }
            this.sessionFactory = factory;
        }

        public void unsetSessionFactory(SessionFactory factory) {
            log.debugf("Un-scoping TypeConfiguration [%s] from SessionFactory [%s]", this, factory);
            this.sessionFactory = null;
        }

        private Object readResolve() throws InvalidObjectException {
            if (this.sessionFactory == null && (this.sessionFactoryName != null || this.sessionFactoryUuid != null)) {
                this.sessionFactory = (SessionFactoryImplementor)SessionFactoryRegistry.INSTANCE.findSessionFactory(this.sessionFactoryUuid, this.sessionFactoryName);
                if (this.sessionFactory == null) {
                    throw new HibernateException("Could not find a SessionFactory [uuid=" + this.sessionFactoryUuid + ",name=" + this.sessionFactoryName + "]");
                }
            }
            return this;
        }
    }

    static interface HqlLiteralResolver {
        public String getKey();

        public <T> SqmLiteral<T> resolveLiteral(String var1);
    }

    static interface CustomExpressionTypeResolver {
        public BasicValuedExpressableType resolveArithmeticType(BasicValuedExpressableType var1, BasicValuedExpressableType var2, boolean var3);

        public BasicValuedExpressableType resolveSumFunctionType(BasicValuedExpressableType var1);

        public BasicType resolveCastTargetType(String var1);
    }

    private class StandardJavaTypeResolutionImpl<J>
    implements BasicTypeResolution<J> {
        private final BasicJavaDescriptor<J> javaTypeDescriptor;
        private final SqlTypeDescriptor sqlTypeDescriptor;
        private final SqlExpressableType sqlExpressableType;

        public StandardJavaTypeResolutionImpl(BasicJavaDescriptor<J> javaTypeDescriptor) {
            this.javaTypeDescriptor = javaTypeDescriptor;
            this.sqlTypeDescriptor = javaTypeDescriptor.getJdbcRecommendedSqlType(TypeConfiguration.this.getCurrentBaseSqlTypeIndicators());
            this.sqlExpressableType = this.sqlTypeDescriptor.getSqlExpressableType(javaTypeDescriptor, TypeConfiguration.this);
        }

        @Override
        public Class<J> getJavaType() {
            return this.getDomainJavaDescriptor().getJavaType();
        }

        @Override
        public BasicJavaDescriptor<J> getDomainJavaDescriptor() {
            return this.javaTypeDescriptor;
        }

        @Override
        public SqlExpressableType getSqlExpressableType() {
            return this.sqlExpressableType;
        }

        @Override
        public BasicValueConverter getValueConverter() {
            return null;
        }

        @Override
        public MutabilityPlan<J> getMutabilityPlan() {
            return this.javaTypeDescriptor.getMutabilityPlan();
        }

        @Override
        public BasicJavaDescriptor<J> getJavaTypeDescriptor() {
            return this.javaTypeDescriptor;
        }

        @Override
        public void visitJdbcTypes(Consumer<SqlExpressableType> action, Clause clause, TypeConfiguration typeConfiguration) {
            action.accept(this.getSqlExpressableType());
        }
    }

    private class StandardBasicTypeResolutionImpl<J>
    implements BasicTypeResolution<J> {
        private final StandardBasicTypes.StandardBasicType<J> standardBasicType;
        private final SqlExpressableType sqlExpressableType;

        public StandardBasicTypeResolutionImpl(StandardBasicTypes.StandardBasicType<J> standardBasicType) {
            this.standardBasicType = standardBasicType;
            this.sqlExpressableType = standardBasicType.getRelationalSqlTypeDescriptor().getSqlExpressableType(standardBasicType.getRelationalJavaTypeDescriptor(), TypeConfiguration.this);
        }

        @Override
        public Class<J> getJavaType() {
            return this.getDomainJavaDescriptor().getJavaType();
        }

        @Override
        public BasicJavaDescriptor<J> getDomainJavaDescriptor() {
            return this.standardBasicType.getDomainJavaTypeDescriptor();
        }

        @Override
        public SqlExpressableType getSqlExpressableType() {
            return this.sqlExpressableType;
        }

        @Override
        public BasicValueConverter getValueConverter() {
            return this.standardBasicType.getValueConverter();
        }

        @Override
        public MutabilityPlan<J> getMutabilityPlan() {
            return this.standardBasicType.getMutabilityPlan();
        }

        @Override
        public BasicJavaDescriptor<J> getJavaTypeDescriptor() {
            return this.standardBasicType.getDomainJavaTypeDescriptor();
        }
    }

    public static interface BasicTypeResolution<J>
    extends BasicValueMapper<J>,
    BasicValuedExpressableType<J>,
    BasicTypeDescriptor<J> {
        @Override
        default public Type.PersistenceType getPersistenceType() {
            return Type.PersistenceType.BASIC;
        }
    }
}

