/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.internal.SessionFactoryBuilderImpl;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.NamedHqlQueryDefinition;
import org.hibernate.boot.spi.NamedNativeQueryDefinition;
import org.hibernate.boot.spi.NamedProcedureCallDefinition;
import org.hibernate.boot.spi.NamedResultSetMappingDefinition;
import org.hibernate.boot.spi.SessionFactoryBuilderFactory;
import org.hibernate.cfg.annotations.NamedEntityGraphDefinition;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.factory.spi.MutableIdentifierGeneratorFactory;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.query.hql.spi.NamedHqlQueryMemento;
import org.hibernate.query.internal.NamedQueryRepositoryImpl;
import org.hibernate.query.named.NamedQueryRepository;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.hibernate.type.Type;
import org.hibernate.type.spi.TypeConfiguration;

public class MetadataImpl
implements MetadataImplementor,
Serializable {
    private final UUID uuid;
    private final MetadataBuildingOptions metadataBuildingOptions;
    private final BootstrapContext bootstrapContext;
    private final MutableIdentifierGeneratorFactory identifierGeneratorFactory;
    private final Map<String, PersistentClass> entityBindingMap;
    private final Map<Class, MappedSuperclass> mappedSuperclassMap;
    private final Map<String, org.hibernate.mapping.Collection> collectionBindingMap;
    private final Map<String, TypeDefinition> typeDefinitionMap;
    private final Map<String, FilterDefinition> filterDefinitionMap;
    private final Map<String, FetchProfile> fetchProfileMap;
    private final Map<String, String> imports;
    private final Map<String, IdentifierGeneratorDefinition> idGeneratorDefinitionMap;
    private final Map<String, NamedHqlQueryDefinition> namedQueryMap;
    private final Map<String, NamedNativeQueryDefinition> namedNativeQueryMap;
    private final Map<String, NamedProcedureCallDefinition> namedProcedureCallMap;
    private final Map<String, NamedResultSetMappingDefinition> sqlResultSetMappingMap;
    private final Map<String, NamedEntityGraphDefinition> namedEntityGraphMap;
    private final Map<String, SQLFunction> sqlFunctionMap;
    private final Database database;

    public MetadataImpl(UUID uuid, MetadataBuildingOptions metadataBuildingOptions, MutableIdentifierGeneratorFactory identifierGeneratorFactory, Map<String, PersistentClass> entityBindingMap, Map<Class, MappedSuperclass> mappedSuperclassMap, Map<String, org.hibernate.mapping.Collection> collectionBindingMap, Map<String, TypeDefinition> typeDefinitionMap, Map<String, FilterDefinition> filterDefinitionMap, Map<String, FetchProfile> fetchProfileMap, Map<String, String> imports, Map<String, IdentifierGeneratorDefinition> idGeneratorDefinitionMap, Map<String, NamedHqlQueryDefinition> namedQueryMap, Map<String, NamedNativeQueryDefinition> namedNativeQueryMap, Map<String, NamedProcedureCallDefinition> namedProcedureCallMap, Map<String, NamedResultSetMappingDefinition> sqlResultSetMappingMap, Map<String, NamedEntityGraphDefinition> namedEntityGraphMap, Map<String, SQLFunction> sqlFunctionMap, Database database, BootstrapContext bootstrapContext) {
        this.uuid = uuid;
        this.metadataBuildingOptions = metadataBuildingOptions;
        this.identifierGeneratorFactory = identifierGeneratorFactory;
        this.entityBindingMap = entityBindingMap;
        this.mappedSuperclassMap = mappedSuperclassMap;
        this.collectionBindingMap = collectionBindingMap;
        this.typeDefinitionMap = typeDefinitionMap;
        this.filterDefinitionMap = filterDefinitionMap;
        this.fetchProfileMap = fetchProfileMap;
        this.imports = imports;
        this.idGeneratorDefinitionMap = idGeneratorDefinitionMap;
        this.namedQueryMap = namedQueryMap;
        this.namedNativeQueryMap = namedNativeQueryMap;
        this.namedProcedureCallMap = namedProcedureCallMap;
        this.sqlResultSetMappingMap = sqlResultSetMappingMap;
        this.namedEntityGraphMap = namedEntityGraphMap;
        this.sqlFunctionMap = sqlFunctionMap;
        this.database = database;
        this.bootstrapContext = bootstrapContext;
    }

    @Override
    public MetadataBuildingOptions getMetadataBuildingOptions() {
        return this.metadataBuildingOptions;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.bootstrapContext.getTypeConfiguration();
    }

    @Override
    public SessionFactoryBuilder getSessionFactoryBuilder() {
        SessionFactoryBuilderImpl defaultBuilder = new SessionFactoryBuilderImpl((MetadataImplementor)this, this.bootstrapContext);
        ClassLoaderService cls = this.metadataBuildingOptions.getServiceRegistry().getService(ClassLoaderService.class);
        Collection<SessionFactoryBuilderFactory> discoveredBuilderFactories = cls.loadJavaServices(SessionFactoryBuilderFactory.class);
        SessionFactoryBuilder builder = null;
        ArrayList<String> activeFactoryNames = null;
        for (SessionFactoryBuilderFactory discoveredBuilderFactory : discoveredBuilderFactories) {
            SessionFactoryBuilder returnedBuilder = discoveredBuilderFactory.getSessionFactoryBuilder(this, defaultBuilder);
            if (returnedBuilder == null) continue;
            if (activeFactoryNames == null) {
                activeFactoryNames = new ArrayList<String>();
            }
            activeFactoryNames.add(discoveredBuilderFactory.getClass().getName());
            builder = returnedBuilder;
        }
        if (activeFactoryNames != null && activeFactoryNames.size() > 1) {
            throw new HibernateException("Multiple active SessionFactoryBuilderFactory definitions were discovered : " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)activeFactoryNames));
        }
        if (builder != null) {
            return builder;
        }
        return defaultBuilder;
    }

    @Override
    public SessionFactory buildSessionFactory() {
        return this.getSessionFactoryBuilder().build();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public MutableIdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.identifierGeneratorFactory;
    }

    @Override
    public Collection<PersistentClass> getEntityBindings() {
        return this.entityBindingMap.values();
    }

    @Override
    public PersistentClass getEntityBinding(String entityName) {
        return this.entityBindingMap.get(entityName);
    }

    @Override
    public Collection<org.hibernate.mapping.Collection> getCollectionBindings() {
        return this.collectionBindingMap.values();
    }

    @Override
    public org.hibernate.mapping.Collection getCollectionBinding(String role) {
        return this.collectionBindingMap.get(role);
    }

    @Override
    public Map<String, String> getImports() {
        return this.imports;
    }

    @Override
    public NamedHqlQueryDefinition getNamedHqlQueryMapping(String name) {
        return this.namedQueryMap.get(name);
    }

    @Override
    public void visitNamedHqlQueryDefinitions(Consumer<NamedHqlQueryDefinition> definitionConsumer) {
        this.namedQueryMap.values().forEach(definitionConsumer);
    }

    @Override
    public NamedNativeQueryDefinition getNamedNativeQueryMapping(String name) {
        return this.namedNativeQueryMap.get(name);
    }

    @Override
    public void visitNamedNativeQueryDefinitions(Consumer<NamedNativeQueryDefinition> definitionConsumer) {
        this.namedNativeQueryMap.values().forEach(definitionConsumer);
    }

    @Override
    public void visitNamedProcedureCallDefinition(Consumer<NamedProcedureCallDefinition> definitionConsumer) {
        this.namedProcedureCallMap.values().forEach(definitionConsumer);
    }

    @Override
    public NamedResultSetMappingDefinition getResultSetMapping(String name) {
        return this.sqlResultSetMappingMap.get(name);
    }

    @Override
    public void visitNamedResultSetMappingDefinition(Consumer<NamedResultSetMappingDefinition> definitionConsumer) {
        this.sqlResultSetMappingMap.values().forEach(definitionConsumer);
    }

    @Override
    public TypeDefinition getTypeDefinition(String typeName) {
        return this.typeDefinitionMap.get(typeName);
    }

    @Override
    public Map<String, FilterDefinition> getFilterDefinitions() {
        return this.filterDefinitionMap;
    }

    @Override
    public FilterDefinition getFilterDefinition(String name) {
        return this.filterDefinitionMap.get(name);
    }

    @Override
    public FetchProfile getFetchProfile(String name) {
        return this.fetchProfileMap.get(name);
    }

    @Override
    public Collection<FetchProfile> getFetchProfiles() {
        return this.fetchProfileMap.values();
    }

    @Override
    public NamedEntityGraphDefinition getNamedEntityGraph(String name) {
        return this.namedEntityGraphMap.get(name);
    }

    @Override
    public Map<String, NamedEntityGraphDefinition> getNamedEntityGraphs() {
        return this.namedEntityGraphMap;
    }

    @Override
    public IdentifierGeneratorDefinition getIdentifierGenerator(String name) {
        return this.idGeneratorDefinitionMap.get(name);
    }

    @Override
    public Map<String, SQLFunction> getSqlFunctionMap() {
        return this.sqlFunctionMap;
    }

    @Override
    public Collection<Table> collectTableMappings() {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Namespace namespace : this.database.getNamespaces()) {
            tables.addAll(namespace.getTables());
        }
        return tables;
    }

    @Override
    public NamedQueryRepository buildNamedQueryRepository(SessionFactoryImplementor sessionFactory) {
        return new NamedQueryRepositoryImpl(this.buildNamedHqlMementos(sessionFactory), this.buildNamedNativeMementos(sessionFactory), this.buildProcedureCallMementos(sessionFactory), this.buildResultSetMappingMementos(sessionFactory));
    }

    private Map<String, NamedHqlQueryMemento> buildNamedHqlMementos(SessionFactoryImplementor sessionFactory) {
        HashMap<String, NamedHqlQueryMemento> map = new HashMap<String, NamedHqlQueryMemento>();
        if (this.namedQueryMap != null) {
            this.namedQueryMap.forEach((key, value) -> map.put((String)key, value.resolve(sessionFactory)));
        }
        return map;
    }

    private Map<String, NamedNativeQueryMemento> buildNamedNativeMementos(SessionFactoryImplementor sessionFactory) {
        HashMap<String, NamedNativeQueryMemento> map = new HashMap<String, NamedNativeQueryMemento>();
        if (this.namedNativeQueryMap != null) {
            this.namedNativeQueryMap.forEach((key, value) -> map.put((String)key, value.resolve(sessionFactory)));
        }
        return map;
    }

    private Map<String, NamedCallableQueryMemento> buildProcedureCallMementos(SessionFactoryImplementor sessionFactory) {
        HashMap<String, NamedCallableQueryMemento> map = new HashMap<String, NamedCallableQueryMemento>();
        if (this.namedProcedureCallMap != null) {
            this.namedProcedureCallMap.forEach((key, value) -> map.put((String)key, value.resolve(sessionFactory)));
        }
        return map;
    }

    private Map<String, NamedResultSetMappingMemento> buildResultSetMappingMementos(SessionFactoryImplementor sessionFactory) {
        HashMap<String, NamedResultSetMappingMemento> map = new HashMap<String, NamedResultSetMappingMemento>();
        if (this.sqlResultSetMappingMap != null) {
            this.sqlResultSetMappingMap.forEach((key, value) -> map.put((String)key, value.resolve(sessionFactory)));
        }
        return map;
    }

    @Override
    public void validate() throws MappingException {
        for (PersistentClass entityBinding : this.getEntityBindings()) {
            entityBinding.validate(this);
        }
        for (org.hibernate.mapping.Collection collectionBinding : this.getCollectionBindings()) {
            collectionBinding.validate(this);
        }
    }

    @Override
    public Set<MappedSuperclass> getMappedSuperclassMappingsCopy() {
        return this.mappedSuperclassMap == null ? Collections.emptySet() : new HashSet<MappedSuperclass>(this.mappedSuperclassMap.values());
    }

    @Override
    public Type getIdentifierType(String entityName) throws MappingException {
        PersistentClass pc = this.entityBindingMap.get(entityName);
        if (pc == null) {
            throw new MappingException("persistent class not known: " + entityName);
        }
        return pc.getIdentifier().getType();
    }

    @Override
    public String getIdentifierPropertyName(String entityName) throws MappingException {
        PersistentClass pc = this.entityBindingMap.get(entityName);
        if (pc == null) {
            throw new MappingException("persistent class not known: " + entityName);
        }
        if (!pc.hasIdentifierProperty()) {
            return null;
        }
        return pc.getIdentifierProperty().getName();
    }

    @Override
    public Type getReferencedPropertyType(String entityName, String propertyName) throws MappingException {
        PersistentClass pc = this.entityBindingMap.get(entityName);
        if (pc == null) {
            throw new MappingException("persistent class not known: " + entityName);
        }
        Property prop = pc.getReferencedProperty(propertyName);
        if (prop == null) {
            throw new MappingException("property not known: " + entityName + '.' + propertyName);
        }
        return prop.getType();
    }

    public Map<String, PersistentClass> getEntityBindingMap() {
        return this.entityBindingMap;
    }

    public Map<String, org.hibernate.mapping.Collection> getCollectionBindingMap() {
        return this.collectionBindingMap;
    }

    public Map<String, TypeDefinition> getTypeDefinitionMap() {
        return this.typeDefinitionMap;
    }

    public Map<String, FetchProfile> getFetchProfileMap() {
        return this.fetchProfileMap;
    }

    public Map<Class, MappedSuperclass> getMappedSuperclassMap() {
        return this.mappedSuperclassMap;
    }

    public Map<String, IdentifierGeneratorDefinition> getIdGeneratorDefinitionMap() {
        return this.idGeneratorDefinitionMap;
    }

    public Map<String, NamedEntityGraphDefinition> getNamedEntityGraphMap() {
        return this.namedEntityGraphMap;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }
}

