/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.NamedStoredProcedureQuery;
import javax.persistence.ParameterMode;
import javax.persistence.StoredProcedureParameter;
import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.boot.spi.NamedProcedureCallDefinition;
import org.hibernate.cfg.annotations.QueryHintDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ParameterStrategy;

public class NamedProcedureCallDefinitionImpl
implements NamedProcedureCallDefinition {
    private final String registeredName;
    private final String procedureName;
    private final Class[] resultClasses;
    private final String[] resultSetMappings;
    private final ParameterDefinitions parameterDefinitions;
    private final Map<String, Object> hints;

    NamedProcedureCallDefinitionImpl(NamedStoredProcedureQuery annotation) {
        boolean specifiesResultSetMappings;
        this.registeredName = annotation.name();
        this.procedureName = annotation.procedureName();
        this.hints = new QueryHintDefinition(this.registeredName, annotation.hints()).getHintsMap();
        this.resultClasses = annotation.resultClasses();
        this.resultSetMappings = annotation.resultSetMappings();
        this.parameterDefinitions = new ParameterDefinitions(annotation.parameters(), this.hints);
        boolean specifiesResultClasses = this.resultClasses != null && this.resultClasses.length > 0;
        boolean bl = specifiesResultSetMappings = this.resultSetMappings != null && this.resultSetMappings.length > 0;
        if (specifiesResultClasses && specifiesResultSetMappings) {
            throw new MappingException(String.format("NamedStoredProcedureQuery [%s] specified both resultClasses and resultSetMappings", this.registeredName));
        }
    }

    @Override
    public String getRegistrationName() {
        return this.registeredName;
    }

    @Override
    public String getProcedureName() {
        return this.procedureName;
    }

    @Override
    public NamedCallableQueryMemento resolve(SessionFactoryImplementor sessionFactory) {
        ArrayList collectedQueryReturns = new ArrayList();
        HashSet collectedQuerySpaces = new HashSet();
        boolean specifiesResultClasses = this.resultClasses != null && this.resultClasses.length > 0;
        boolean specifiesResultSetMappings = this.resultSetMappings != null && this.resultSetMappings.length > 0;
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    private static String normalize(String name) {
        return StringHelper.isNotEmpty(name) ? name : null;
    }

    static class ParameterDefinition {
        private final Integer position;
        private final String name;
        private final ParameterMode parameterMode;
        private final Class type;
        private final Boolean explicitPassNullSetting;

        static ParameterDefinition from(ParameterStrategy parameterStrategy, StoredProcedureParameter parameterAnnotation, int adjustedPosition, Map<String, Object> queryHintMap) {
            Object explicitNullPassingHint = parameterStrategy == ParameterStrategy.NAMED ? queryHintMap.get("hibernate.proc.param_null_passing." + parameterAnnotation.name()) : queryHintMap.get("hibernate.proc.param_null_passing." + adjustedPosition);
            return new ParameterDefinition(adjustedPosition, parameterAnnotation, ParameterDefinition.interpretBoolean(explicitNullPassingHint));
        }

        private static Boolean interpretBoolean(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return Boolean.valueOf(value.toString());
        }

        ParameterDefinition(int position, StoredProcedureParameter annotation, Boolean explicitPassNullSetting) {
            this.position = position;
            this.name = NamedProcedureCallDefinitionImpl.normalize(annotation.name());
            this.parameterMode = annotation.mode();
            this.type = annotation.type();
            this.explicitPassNullSetting = explicitPassNullSetting;
        }

        public NamedCallableQueryMemento.ParameterMemento toMemento(SessionFactoryImplementor sessionFactory) {
            boolean initialPassNullSetting = this.explicitPassNullSetting != null ? this.explicitPassNullSetting.booleanValue() : sessionFactory.getSessionFactoryOptions().isProcedureParameterNullPassingEnabled();
            throw new NotYetImplementedFor6Exception(this.getClass());
        }
    }

    static class ParameterDefinitions {
        private final ParameterStrategy parameterStrategy;
        private final ParameterDefinition[] parameterDefinitions;

        ParameterDefinitions(StoredProcedureParameter[] parameters, Map<String, Object> queryHintMap) {
            if (parameters == null || parameters.length == 0) {
                this.parameterStrategy = ParameterStrategy.POSITIONAL;
                this.parameterDefinitions = new ParameterDefinition[0];
            } else {
                this.parameterStrategy = StringHelper.isNotEmpty(parameters[0].name()) ? ParameterStrategy.NAMED : ParameterStrategy.POSITIONAL;
                this.parameterDefinitions = new ParameterDefinition[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    this.parameterDefinitions[i] = ParameterDefinition.from(this.parameterStrategy, parameters[i], i + 1, queryHintMap);
                }
            }
        }

        public ParameterStrategy getParameterStrategy() {
            return this.parameterStrategy;
        }

        public List<NamedCallableQueryMemento.ParameterMemento> toMementos(SessionFactoryImplementor sessionFactory) {
            ArrayList<NamedCallableQueryMemento.ParameterMemento> mementos = new ArrayList<NamedCallableQueryMemento.ParameterMemento>();
            for (ParameterDefinition definition : this.parameterDefinitions) {
                mementos.add(definition.toMemento(sessionFactory));
            }
            return mementos;
        }
    }
}

